/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.enrolment;

import java.util.Collection;
import java.util.HashSet;
import java.util.function.Supplier;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.accessControl.AcademicAuthorizationGroup;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.curriculum.EnrolmentEvaluationContext;
import org.fenixedu.academic.domain.enrolment.EnrolmentServices;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonServices;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.security.Authenticate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EnrolmentPredicateInitializer {
    private static final Logger logger = LoggerFactory.getLogger(EnrolmentPredicateInitializer.class);
    protected static Collection<Enrolment.EnrolmentPredicate> EXTRA_NORMAL_PREDICATES = new HashSet<Enrolment.EnrolmentPredicate>();
    protected static Collection<Enrolment.EnrolmentPredicate> EXTRA_IMPROVEMENT_PREDICATES = new HashSet<Enrolment.EnrolmentPredicate>();
    private static Collection<Enrolment.EnrolmentPredicate> EXTRA_SPECIAL_PREDICATES = new HashSet<Enrolment.EnrolmentPredicate>();
    private static Supplier<Enrolment.EnrolmentPredicate> PREDICATE_SEASON = () -> new Enrolment.EnrolmentPredicate(){

        public boolean test(Enrolment enrolment) {
            if (enrolment.isEvaluatedInSeason(this.getEvaluationSeason(), this.getExecutionSemester())) {
                throw new DomainException("error.EvaluationSeason.enrolment.evaluated.in.this.season", new String[]{enrolment.getPresentationName().getContent(), this.getEvaluationSeason().getName().getContent()});
            }
            if (this.getContext() == EnrolmentEvaluationContext.MARK_SHEET_EVALUATION) {
                if (enrolment.isEnroledInSeason(this.getEvaluationSeason(), this.getExecutionSemester())) {
                    throw new DomainException("error.EvaluationSeason.already.enroled.in.this.season", new String[]{enrolment.getPresentationName().getContent(), this.getEvaluationSeason().getName().getContent()});
                }
                if (enrolment.isApproved() && !EvaluationSeasonServices.isForApprovedEnrolments(this.getEvaluationSeason())) {
                    throw new DomainException("error.EvaluationSeason.evaluation.already.approved", new String[]{enrolment.getPresentationName().getContent(), this.getEvaluationSeason().getName().getContent()});
                }
            }
            if (enrolment.getEvaluationsSet().stream().anyMatch(evaluation -> evaluation.getEvaluationSeason() == this.getEvaluationSeason() && evaluation.isFinal() && evaluation.isApproved())) {
                throw new DomainException("error.EvaluationSeason.already.approved.in.this.season", new String[]{enrolment.getPresentationName().getContent(), this.getEvaluationSeason().getName().getContent()});
            }
            if (EXTRA_NORMAL_PREDICATES.stream().anyMatch(p -> !p.test((Object)enrolment))) {
                throw new DomainException("error.EvaluationSeason.extra.normal.predicate.evaluation.failed", new String[0]);
            }
            return true;
        }
    };
    private static Supplier<Enrolment.EnrolmentPredicate> PREDICATE_IMPROVEMENT = () -> new Enrolment.EnrolmentPredicate(){

        public boolean test(Enrolment enrolment) {
            ExecutionSemester improvementSemester = this.getExecutionSemester();
            ExecutionSemester enrolmentSemester = enrolment.getExecutionPeriod();
            String name = enrolment.getPresentationName().getContent();
            if (improvementSemester.isBefore(enrolmentSemester)) {
                throw new DomainException("error.EnrolmentEvaluation.improvement.semester.must.be.after.or.equal.enrolment", new String[]{name});
            }
            if (enrolment.isAnual() && !improvementSemester.isFirstOfYear()) {
                throw new DomainException("error.EnrolmentEvaluation.improvement.semester.must.be.first.of.year.for.anual.courses", new String[]{name});
            }
            if (!enrolment.isApproved()) {
                throw new DomainException("curricularRules.ruleExecutors.ImprovementOfApprovedEnrolmentExecutor.degree.module.hasnt.been.approved", new String[]{name});
            }
            if (EnrolmentServices.getExecutionCourses(enrolment, improvementSemester).isEmpty()) {
                throw new DomainException("error.EnrolmentEvaluation.improvement.required.ExecutionCourse", new String[]{name, improvementSemester.getQualifiedName()});
            }
            if (EXTRA_IMPROVEMENT_PREDICATES.stream().anyMatch(p -> !p.test((Object)enrolment))) {
                throw new DomainException("error.EvaluationSeason.extra.improvement.predicate.evaluation.failed", new String[0]);
            }
            ((Enrolment.EnrolmentPredicate)PREDICATE_SEASON.get()).fill(this.getEvaluationSeason(), improvementSemester, this.getContext()).test((Object)enrolment);
            return true;
        }
    };
    private static Supplier<Enrolment.EnrolmentPredicate> PREDICATE_SPECIAL_SEASON = () -> new Enrolment.EnrolmentPredicate(){

        public boolean test(Enrolment enrolment) {
            ExecutionSemester enrolmentSemester;
            ExecutionSemester specialSeasonSemester = this.getExecutionSemester();
            if (specialSeasonSemester != (enrolmentSemester = enrolment.getExecutionPeriod())) {
                throw new DomainException("error.EnrolmentEvaluation.special.season.semester.must.be", new String[]{enrolment.getPresentationName().getContent()});
            }
            if (enrolment.isApproved()) {
                throw new DomainException("curricularRules.ruleExecutors.EnrolmentInSpecialSeasonEvaluationExecutor.degree.module.has.been.approved", new String[]{enrolment.getPresentationName().getContent()});
            }
            if (EXTRA_SPECIAL_PREDICATES.stream().anyMatch(p -> !p.test((Object)enrolment))) {
                throw new DomainException("error.EvaluationSeason.extra.special.predicate.evaluation.failed", new String[0]);
            }
            ((Enrolment.EnrolmentPredicate)PREDICATE_SEASON.get()).fill(this.getEvaluationSeason(), this.getExecutionSemester(), this.getContext()).test((Object)enrolment);
            boolean isServices = AcademicAuthorizationGroup.get((AcademicOperationType)AcademicOperationType.STUDENT_ENROLMENTS).isMember(Authenticate.getUser());
            return this.considerThisEnrolmentNormalEnrolments(enrolment) || this.considerThisEnrolmentPropaedeuticEnrolments(enrolment, isServices) || this.considerThisEnrolmentExtraCurricularEnrolments(enrolment, isServices) || this.considerThisEnrolmentStandaloneEnrolments(enrolment, isServices);
        }

        private boolean considerThisEnrolmentNormalEnrolments(Enrolment enrolment) {
            if (enrolment.isBolonhaDegree() && !enrolment.isExtraCurricular() && !enrolment.isPropaedeutic() && !enrolment.isStandalone() && enrolment.getParentCycleCurriculumGroup().isConclusionProcessed()) {
                return false;
            }
            return !enrolment.parentCurriculumGroupIsNoCourseGroupCurriculumGroup() || enrolment.isPropaedeutic();
        }

        private boolean considerThisEnrolmentPropaedeuticEnrolments(Enrolment enrolment, boolean isServices) {
            return enrolment.isPropaedeutic() && isServices;
        }

        private boolean considerThisEnrolmentExtraCurricularEnrolments(Enrolment enrolment, boolean isServices) {
            return enrolment.isExtraCurricular() && isServices;
        }

        private boolean considerThisEnrolmentStandaloneEnrolments(Enrolment enrolment, boolean isServices) {
            return enrolment.isStandalone() && isServices;
        }
    };

    public static void addExtraNormalPredicate(Enrolment.EnrolmentPredicate predicate) {
        EXTRA_NORMAL_PREDICATES.add(predicate);
    }

    public static void addExtraImprovementPredicate(Enrolment.EnrolmentPredicate predicate) {
        EXTRA_IMPROVEMENT_PREDICATES.add(predicate);
    }

    public static void addExtraSpecialPredicate(Enrolment.EnrolmentPredicate predicate) {
        EXTRA_SPECIAL_PREDICATES.add(predicate);
    }

    public static void init() {
        Enrolment.setPredicateSeason(PREDICATE_SEASON);
        Enrolment.setPredicateImprovement(PREDICATE_IMPROVEMENT);
        Enrolment.setPredicateSpecialSeason(PREDICATE_SPECIAL_SEASON);
    }
}

