/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.StudentSchoolClassCurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnroledOptionalEnrolment;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.enrolment.OptionalDegreeModuleToEnrol;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academicextensions.util.AcademicExtensionsUtil;

public class StudentSchoolClassCurricularRuleExecutor
extends CurricularRuleExecutor {
    protected RuleResult executeEnrolmentInEnrolmentEvaluation(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return RuleResult.createNA((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    protected boolean canBeEvaluated(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return true;
    }

    @Deprecated
    protected RuleResult executeEnrolmentWithRulesAndTemporaryEnrolment(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return this.executeEnrolmentVerificationWithRules(curricularRule, sourceDegreeModuleToEvaluate, enrolmentContext);
    }

    protected RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        if (sourceDegreeModuleToEvaluate.isEnroled() || !this.canApplyRule(enrolmentContext, curricularRule) || !sourceDegreeModuleToEvaluate.isLeaf() || sourceDegreeModuleToEvaluate.getExecutionPeriod() != enrolmentContext.getExecutionPeriod()) {
            return RuleResult.createNA((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        if (sourceDegreeModuleToEvaluate instanceof OptionalDegreeModuleToEnrol || sourceDegreeModuleToEvaluate instanceof EnroledOptionalEnrolment) {
            return RuleResult.createNA((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        StudentSchoolClassCurricularRule schoolClassCurricularRule = (StudentSchoolClassCurricularRule)curricularRule;
        Registration registration = enrolmentContext.getRegistration();
        ExecutionSemester executionSemester = sourceDegreeModuleToEvaluate.getExecutionPeriod();
        CurricularCourse curricularCourse = (CurricularCourse)sourceDegreeModuleToEvaluate.getDegreeModule();
        if (schoolClassCurricularRule.getSchoolClassMustContainCourse().booleanValue()) {
            int curricularYear = RegistrationServices.getCurricularYear(registration, executionSemester.getExecutionYear()).getResult();
            if (sourceDegreeModuleToEvaluate.getContext().getCurricularYear().equals(curricularYear) && registration.getSchoolClassesSet().stream().filter(sc -> sc.getExecutionPeriod() == executionSemester).flatMap(sc -> sc.getAssociatedShiftsSet().stream().map(s -> s.getExecutionCourse()).flatMap(ec -> ec.getAssociatedCurricularCoursesSet().stream())).noneMatch(cc -> cc == curricularCourse)) {
                return RuleResult.createFalseWithLiteralMessage((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule(), (String)AcademicExtensionsUtil.bundle("curricularRules.ruleExecutors.StudentSchoolClassCurricularRuleExecutor.error.schoolClassMustContainCourse", executionSemester.getName(), curricularCourse.getCode(), curricularCourse.getName()));
            }
        }
        if (schoolClassCurricularRule.getCourseMustHaveFreeShifts().booleanValue()) {
            Set registrationSchoolClasses = registration.getSchoolClassesSet().stream().filter(sc -> sc.getExecutionPeriod() == executionSemester).collect(Collectors.toSet());
            if (!registrationSchoolClasses.isEmpty()) {
                for (SchoolClass schoolClass : registrationSchoolClasses) {
                    DegreeCurricularPlan degreeCurricularPlan = schoolClass.getExecutionDegree().getDegreeCurricularPlan();
                    Set<Shift> shifts = schoolClass.getAssociatedShiftsSet().stream().filter(s -> s.getExecutionCourse().getCurricularCourseFor(degreeCurricularPlan) == curricularCourse).collect(Collectors.toSet());
                    ArrayListMultimap shiftsTypesByShift = ArrayListMultimap.create();
                    shifts.forEach(arg_0 -> StudentSchoolClassCurricularRuleExecutor.lambda$executeEnrolmentVerificationWithRules$8((Multimap)shiftsTypesByShift, arg_0));
                    for (ShiftType shiftType : shiftsTypesByShift.keySet()) {
                        Collection shiftsForType = shiftsTypesByShift.get((Object)shiftType);
                        if (!shiftsForType.stream().noneMatch(s -> s.getStudentsSet().contains(registration)) || !shiftsForType.stream().noneMatch(s -> StudentSchoolClassCurricularRuleExecutor.isFree(s))) continue;
                        return RuleResult.createFalseWithLiteralMessage((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule(), (String)AcademicExtensionsUtil.bundle("curricularRules.ruleExecutors.StudentSchoolClassCurricularRuleExecutor.error.courseMustHaveFreeShiftsInSchoolClass", curricularCourse.getCode(), curricularCourse.getName()));
                    }
                }
            } else {
                Set allShifts = curricularCourse.getExecutionCoursesByExecutionPeriod((ExecutionInterval)executionSemester).stream().flatMap(ec -> ec.getAssociatedShifts().stream()).collect(Collectors.toSet());
                Set allShiftsTypes = allShifts.stream().flatMap(s -> s.getTypes().stream()).collect(Collectors.toSet());
                for (ShiftType shiftType : allShiftsTypes) {
                    if (!allShifts.stream().filter(s -> s.getTypes().contains(shiftType)).noneMatch(s -> StudentSchoolClassCurricularRuleExecutor.isFree(s))) continue;
                    return RuleResult.createFalseWithLiteralMessage((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule(), (String)AcademicExtensionsUtil.bundle("curricularRules.ruleExecutors.StudentSchoolClassCurricularRuleExecutor.error.courseMustHaveFreeShifts", curricularCourse.getCode(), curricularCourse.getName()));
                }
            }
        }
        if (StringUtils.isNotBlank((String)schoolClassCurricularRule.getSchoolClassNames()) && schoolClassCurricularRule.getSchoolClasses(executionSemester).stream().noneMatch(sc -> sc.getRegistrationsSet().contains(registration))) {
            return RuleResult.createFalseWithLiteralMessage((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule(), (String)AcademicExtensionsUtil.bundle("curricularRules.ruleExecutors.StudentSchoolClassCurricularRuleExecutor.error.registrationNotForSchoolClass", curricularCourse.getCode(), curricularCourse.getName()));
        }
        return RuleResult.createTrue((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    private static boolean isFree(Shift shift) {
        return shift.getLotacao() - shift.getStudentsSet().size() > 0;
    }

    private static /* synthetic */ void lambda$executeEnrolmentVerificationWithRules$8(Multimap shiftsTypesByShift, Shift s) {
        s.getTypes().forEach(st -> shiftsTypesByShift.put(st, (Object)s));
    }
}

