/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.fenixedu.academic.FenixEduAcademicExtensionsConfiguration;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curricularRules.CreditsLimitWithPreviousApprovals;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleServices;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.PreviousYearsEnrolmentBySemesterExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.PreviousYearsEnrolmentByYearExecutor;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseServices;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CurricularRuleConfigurationInitializer {
    private static final Logger logger = LoggerFactory.getLogger(CurricularRuleConfigurationInitializer.class);
    private static SkipCollectCurricularCoursesOrPredicate PREVIOUS_YEARS_ENROLMENT_COURSES_SKIP_PREDICATE = new SkipCollectCurricularCoursesOrPredicate();
    private static Supplier<CurricularRuleExecutor.CurricularRuleApprovalExecutor> CURRICULAR_RULE_APPROVAL_EXECUTOR = () -> new CurricularRuleExecutor.CurricularRuleApprovalExecutor(){

        public boolean isApproved(EnrolmentContext enrolmentContext, CurricularCourse curricularCourse) {
            return this.isApproved(enrolmentContext, curricularCourse, null);
        }

        public boolean isApproved(EnrolmentContext enrolmentContext, CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
            StudentCurricularPlan plan = enrolmentContext.getStudentCurricularPlan();
            if (FenixEduAcademicExtensionsConfiguration.getConfiguration().getCurricularRulesApprovalsAwareOfCompetenceCourse().booleanValue()) {
                return CompetenceCourseServices.isCompetenceCourseApproved(plan, curricularCourse, executionSemester);
            }
            return plan.isApproved(curricularCourse, executionSemester);
        }
    };

    public static void addPreviousYearsEnrolmentCoursesSkipPredicate(PreviousYearsEnrolmentByYearExecutor.SkipCollectCurricularCoursesPredicate predicate) {
        PREVIOUS_YEARS_ENROLMENT_COURSES_SKIP_PREDICATE.addPredicate(predicate);
    }

    public static void init() {
        CurricularRuleExecutor.setCurricularRuleApprovalExecutor(CURRICULAR_RULE_APPROVAL_EXECUTOR);
        logger.info("CurricularRuleApprovalExecutor: Overriding default");
        PreviousYearsEnrolmentBySemesterExecutor.setSkipCollectCurricularCoursesPredicate((PreviousYearsEnrolmentByYearExecutor.SkipCollectCurricularCoursesPredicate)PREVIOUS_YEARS_ENROLMENT_COURSES_SKIP_PREDICATE);
        PreviousYearsEnrolmentByYearExecutor.setSkipCollectCurricularCoursesPredicate((PreviousYearsEnrolmentByYearExecutor.SkipCollectCurricularCoursesPredicate)PREVIOUS_YEARS_ENROLMENT_COURSES_SKIP_PREDICATE);
        CurricularRuleConfigurationInitializer.addPreviousYearsEnrolmentCoursesSkipPredicate((cg, ctx) -> CurricularRuleConfigurationInitializer.skipByCreditsLimitWithPreviousApprovals(cg, ctx));
    }

    private static boolean skipByCreditsLimitWithPreviousApprovals(CourseGroup courseGroup, EnrolmentContext enrolmentContext) {
        CurriculumGroup curriculumGroup = enrolmentContext.getStudentCurricularPlan().findCurriculumGroupFor(courseGroup);
        if (curriculumGroup == null) {
            return false;
        }
        Registration registration = enrolmentContext.getRegistration();
        if (!RegistrationServices.isCurriculumAccumulated(registration)) {
            return false;
        }
        List<? extends ICurricularRule> rules = CurricularRuleServices.getCurricularRules((DegreeModule)curriculumGroup.getDegreeModule(), CreditsLimitWithPreviousApprovals.class, (ExecutionInterval)enrolmentContext.getExecutionPeriod());
        if (rules.isEmpty()) {
            return false;
        }
        double ectsFromPrevious = CurricularRuleServices.calculateEctsCreditsFromPreviousGroups(enrolmentContext, (CreditsLimitWithPreviousApprovals)rules.iterator().next());
        double minEctsToApprove = curriculumGroup.getDegreeModule().getMinEctsCredits();
        double totalEcts = CurricularRuleServices.calculateTotalEctsInGroup(enrolmentContext, curriculumGroup) + ectsFromPrevious;
        return totalEcts >= minEctsToApprove;
    }

    public static class SkipCollectCurricularCoursesOrPredicate
    implements PreviousYearsEnrolmentByYearExecutor.SkipCollectCurricularCoursesPredicate {
        private static Collection<PreviousYearsEnrolmentByYearExecutor.SkipCollectCurricularCoursesPredicate> predicates = new HashSet<PreviousYearsEnrolmentByYearExecutor.SkipCollectCurricularCoursesPredicate>();

        public void addPredicate(PreviousYearsEnrolmentByYearExecutor.SkipCollectCurricularCoursesPredicate predicate) {
            predicates.add(predicate);
        }

        public boolean skip(CourseGroup courseGroup, EnrolmentContext enrolmentContext) {
            return predicates.stream().anyMatch(p -> p.skip(courseGroup, enrolmentContext));
        }
    }
}

