/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.curricularPeriod.transition;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodConfiguration;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.transition.FlunkedCredits$callable$create;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.transition.FlunkedCredits$callable$createForYear;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.transition.FlunkedCredits$callable$createForYearInterval;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.transition.FlunkedCredits_Base;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.degreeStructure.CurricularPeriodServices;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.student.curriculum.ICurriculum;
import org.fenixedu.academic.domain.student.services.StatuteServices;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarRootEntry;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class FlunkedCredits
extends FlunkedCredits_Base {
    public static final BigDecimal FLUNKED_CREDITS_BY_YEAR;
    public static final Advice advice$create;
    public static final Advice advice$createForYear;
    public static final Advice advice$createForYearInterval;

    protected FlunkedCredits() {
    }

    public static FlunkedCredits create(CurricularPeriodConfiguration curricularPeriodConfiguration, BigDecimal bigDecimal) {
        return (FlunkedCredits)((Object)advice$create.perform((Callable)new FlunkedCredits$callable$create(curricularPeriodConfiguration, bigDecimal)));
    }

    static /* synthetic */ FlunkedCredits advised$create(CurricularPeriodConfiguration configuration, BigDecimal credits) {
        return FlunkedCredits.createForYear(configuration, credits, null);
    }

    public static FlunkedCredits createForYear(CurricularPeriodConfiguration curricularPeriodConfiguration, BigDecimal bigDecimal, Integer n) {
        return (FlunkedCredits)((Object)advice$createForYear.perform((Callable)new FlunkedCredits$callable$createForYear(curricularPeriodConfiguration, bigDecimal, n)));
    }

    static /* synthetic */ FlunkedCredits advised$createForYear(CurricularPeriodConfiguration configuration, BigDecimal credits, Integer year) {
        return FlunkedCredits.createForYearInterval(configuration, credits, year, year);
    }

    public static FlunkedCredits createForYearInterval(CurricularPeriodConfiguration curricularPeriodConfiguration, BigDecimal bigDecimal, Integer n, Integer n2) {
        return (FlunkedCredits)((Object)advice$createForYearInterval.perform((Callable)new FlunkedCredits$callable$createForYearInterval(curricularPeriodConfiguration, bigDecimal, n, n2)));
    }

    static /* synthetic */ FlunkedCredits advised$createForYearInterval(CurricularPeriodConfiguration configuration, BigDecimal credits, Integer yearMin, Integer yearMax) {
        FlunkedCredits result = new FlunkedCredits();
        result.init(configuration, credits, yearMin, yearMax);
        return result;
    }

    public StatuteType getStatuteType() {
        return super.getStatuteTypeForRuleTransition();
    }

    public String getLabel() {
        if (this.getYearMin() == null) {
            return BundleUtil.getString((String)MODULE_BUNDLE, (String)("label." + ((Object)((Object)this)).getClass().getSimpleName() + ".total"), (String[])new String[]{this.getCredits().toString()});
        }
        if (this.isForYear()) {
            return BundleUtil.getString((String)MODULE_BUNDLE, (String)("label." + ((Object)((Object)this)).getClass().getSimpleName() + ".year"), (String[])new String[]{this.getCredits().toString(), this.getYearMin().toString()});
        }
        return BundleUtil.getString((String)MODULE_BUNDLE, (String)("label." + ((Object)((Object)this)).getClass().getSimpleName()), (String[])new String[]{this.getCredits().toString(), this.getYearMin().toString(), this.getYearMax().toString()});
    }

    public RuleResult execute(Curriculum input) {
        int yearMax;
        int yearMin;
        if (this.getStatuteType() != null) {
            ExecutionYear executionYear;
            Registration registration = input.getStudentCurricularPlan().getRegistration();
            ExecutionYear executionYear2 = executionYear = input.getExecutionYear() == null ? ExecutionYear.findCurrent((AcademicCalendarRootEntry)registration.getDegree().getCalendar()) : input.getExecutionYear();
            if (StatuteServices.findStatuteTypes(registration, (ExecutionInterval)executionYear).stream().noneMatch(i -> this.getStatuteType() == i)) {
                return this.createFalseLabelled(this.getMessagesSuffix(this.getStatuteType()));
            }
        }
        Curriculum curriculum = this.prepareCurriculum(input);
        if (this.getYearMin() != null) {
            yearMin = this.getYearMin();
            yearMax = this.getYearMax();
        } else {
            yearMin = 1;
            yearMax = Math.max(1, this.getConfiguration().getCurricularPeriod().getChildOrder() - 1);
        }
        Set configured = this.getCurricularPeriodsConfigured(yearMin, yearMax, false);
        if (configured == null) {
            return this.createFalseConfiguration();
        }
        BigDecimal totalFlunked = this.calculateTotalFlunked(curriculum, configured);
        return totalFlunked.compareTo(this.getCredits()) <= 0 ? this.createTrue() : (this.getStatuteType() != null ? this.createFalseLabelled(this.getMessagesSuffix(this.getStatuteType())) : this.createFalseLabelled(totalFlunked));
    }

    private BigDecimal calculateTotalFlunked(Curriculum curriculum, Set<CurricularPeriod> configured) {
        BigDecimal result = BigDecimal.ZERO;
        Map<CurricularPeriod, BigDecimal> curricularPeriodCredits = CurricularPeriodServices.mapYearCredits((ICurriculum)curriculum, this.getApplyToOptionals());
        Set<CurricularPeriod> toInspect = configured.isEmpty() ? curricularPeriodCredits.keySet() : configured;
        for (CurricularPeriod curricularPeriod : toInspect) {
            BigDecimal approved = curricularPeriodCredits.get(curricularPeriod) != null ? curricularPeriodCredits.get(curricularPeriod) : BigDecimal.ZERO;
            BigDecimal approvedWithLimit = this.getFlunkedCreditsBaseline().min(approved);
            BigDecimal flunked = this.getFlunkedCreditsBaseline().subtract(approvedWithLimit);
            result = result.add(flunked);
        }
        return result;
    }

    private BigDecimal getFlunkedCreditsBaseline() {
        return FLUNKED_CREDITS_BY_YEAR.divide(BigDecimal.valueOf(this.getSemester() == null ? 1L : 2L));
    }

    private String getMessagesSuffix(StatuteType input) {
        return input == null ? "" : this.getMessagesSuffix("label." + ((Object)((Object)this)).getClass().getSimpleName() + ".suffix", new String[]{input.getName().getContent()});
    }

    static {
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$createForYear = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$createForYearInterval = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        FLUNKED_CREDITS_BY_YEAR = BigDecimal.valueOf(60L);
    }
}

