/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import java.util.Collections;
import java.util.Optional;
import java.util.SortedSet;
import java.util.function.Consumer;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.curricularRules.StudentSchoolClassCurricularRule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;

public class StudentScheduleListeners {
    public static Consumer<DomainObjectEvent<Enrolment>> SHIFTS_ENROLLER = new Consumer<DomainObjectEvent<Enrolment>>(){

        @Override
        public void accept(DomainObjectEvent<Enrolment> event) {
            boolean enrolInShiftIfUnique;
            ExecutionSemester executionSemester;
            Enrolment enrolment = (Enrolment)event.getInstance();
            Attends attends = enrolment.getAttendsFor((ExecutionInterval)(executionSemester = enrolment.getExecutionPeriod()));
            if (attends == null) {
                return;
            }
            boolean bl = enrolInShiftIfUnique = !enrolment.getCurriculumGroup().isNoCourseGroupCurriculumGroup() && enrolment.getCurricularRules(executionSemester).stream().filter(cr -> cr instanceof StudentSchoolClassCurricularRule).map(cr -> (StudentSchoolClassCurricularRule)((Object)cr)).anyMatch(ssccr -> ssccr.getEnrolInShiftIfUnique());
            if (enrolInShiftIfUnique) {
                Registration registration = enrolment.getRegistration();
                ExecutionCourse executionCourse = attends.getExecutionCourse();
                Optional<SchoolClass> schoolClassOpt = RegistrationServices.getSchoolClassBy(registration, executionSemester);
                if (schoolClassOpt.isPresent()) {
                    block6: {
                        try {
                            RegistrationServices.enrolInSchoolClassExecutionCoursesShifts(registration, schoolClassOpt.get(), Collections.singletonList(executionCourse));
                        }
                        catch (DomainException e) {
                            if ("label.schoolClassStudentEnrollment.fullSchoolClass".equals(e.getKey())) break block6;
                            throw e;
                        }
                    }
                    return;
                }
                for (ShiftType shiftType : executionCourse.getShiftTypes()) {
                    Shift shift;
                    SortedSet shiftsByType = executionCourse.getShiftsByTypeOrderedByShiftName(shiftType);
                    if (shiftsByType.size() != 1 || (shift = (Shift)shiftsByType.iterator().next()).getStudentsSet().contains(registration)) continue;
                    shift.reserveForStudent(registration);
                }
            }
        }
    };
}

