/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.CreditsLimitWithPreviousApprovals_Base;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CreditsLimitWithPreviousApprovalsExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.GenericPair;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class CreditsLimitWithPreviousApprovals
extends CreditsLimitWithPreviousApprovals_Base {
    protected CreditsLimitWithPreviousApprovals() {
    }

    public CreditsLimitWithPreviousApprovals(DegreeModule toApplyRule, CourseGroup contextCourseGroup, ExecutionSemester begin, ExecutionSemester end, Set<CourseGroup> previousGroups) {
        this();
        this.init(toApplyRule, contextCourseGroup, begin, end, CurricularRuleType.CUSTOM);
        this.edit(contextCourseGroup, previousGroups);
    }

    public void edit(CourseGroup contextCourseGroup, Set<CourseGroup> previousGroups) {
        this.setContextCourseGroup(contextCourseGroup);
        this.getPreviousGroupsSet().clear();
        this.getPreviousGroupsSet().addAll(previousGroups);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getPreviousGroupsSet() == null) {
            throw new DomainException("error.CreditsLimitWithPreviousApprovals.required.PreviousGroups", new String[0]);
        }
    }

    public RuleResult evaluate(IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return new CreditsLimitWithPreviousApprovalsExecutor().execute((ICurricularRule)this, sourceDegreeModuleToEvaluate, enrolmentContext);
    }

    public VerifyRuleExecutor createVerifyRuleExecutor() {
        return VerifyRuleExecutor.NULL_VERIFY_EXECUTOR;
    }

    protected void removeOwnParameters() {
        this.getPreviousGroupsSet().clear();
    }

    public List<GenericPair<Object, Boolean>> getLabel() {
        StringBuilder label = new StringBuilder();
        label.append(BundleUtil.getString((String)"resources.FenixeduAcademicExtensionsResources", (String)"label.CreditsLimitWithPreviousApprovals", (String[])new String[0]));
        if (this.getContextCourseGroup() != null) {
            label.append(", ");
            label.append(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"label.inGroup", (String[])new String[0]));
            label.append(" ");
            label.append(this.getContextCourseGroup().getOneFullName());
        }
        return Lists.newArrayList((Object[])new GenericPair[]{new GenericPair((Object)label, (Object)false)});
    }

    public boolean isVisible() {
        return false;
    }
}

