/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academicextensions.domain.person.dataShare;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academicextensions.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academicextensions.domain.person.dataShare.DataShareAuthorizationType$callable$create;
import org.fenixedu.academicextensions.domain.person.dataShare.DataShareAuthorizationType$callable$delete;
import org.fenixedu.academicextensions.domain.person.dataShare.DataShareAuthorizationType$callable$edit;
import org.fenixedu.academicextensions.domain.person.dataShare.DataShareAuthorizationType_Base;
import org.fenixedu.academicextensions.util.AcademicExtensionsUtil;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class DataShareAuthorizationType
extends DataShareAuthorizationType_Base {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected DataShareAuthorizationType() {
        this.setRoot(Bennu.getInstance());
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new DataShareAuthorizationType$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(DataShareAuthorizationType this_) {
        this_.setRoot(null);
        this_.setDataShareAuthorizationTypeParent(null);
        this_.getChoiceSet().clear();
        while (!this_.getDataShareAuthorizationTypeChildrenSet().isEmpty()) {
            ((DataShareAuthorizationType)((Object)this_.getDataShareAuthorizationTypeChildrenSet().iterator().next())).delete();
        }
        AcademicExtensionsDomainException.throwWhenDeleteBlocked(this_.getDeletionBlockers());
        super.deleteDomainObject();
    }

    public boolean isDeletable() {
        return this.getAuthorizationSet().isEmpty() && !this.getDataShareAuthorizationTypeChildrenSet().stream().filter(x -> !x.isDeletable()).findAny().isPresent();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getAuthorizationSet().isEmpty()) {
            blockers.add(AcademicExtensionsUtil.bundle("error.DataShareAuthorizationType.has.Authorizations", new String[0]));
        }
    }

    protected void init(String code, LocalizedString name, String groupExpression, boolean active, LocalizedString question) {
        this.setCode(code);
        this.setName(name);
        this.setGroupExpression(groupExpression);
        this.setActive(active);
        this.setQuestion(question);
        this.checkRules();
    }

    public void checkRules() {
        if (StringUtils.isBlank((String)this.getCode())) {
            throw new AcademicExtensionsDomainException("error.DataShareAuthorizationType.code.required", new String[0]);
        }
        if (this.getName() == null || this.getName().isEmpty()) {
            throw new AcademicExtensionsDomainException("error.DataShareAuthorizationType.name.required", new String[0]);
        }
        if (StringUtils.isBlank((String)this.getGroupExpression())) {
            throw new AcademicExtensionsDomainException("error.DataShareAuthorizationType.groupExpression.required", new String[0]);
        }
        if (this.getQuestion() == null || this.getQuestion().isEmpty()) {
            throw new AcademicExtensionsDomainException("error.DataShareAuthorizationType.question.required", new String[0]);
        }
        DataShareAuthorizationType.findUnique(this.getCode());
    }

    public static DataShareAuthorizationType create(String string, LocalizedString localizedString, String string2, boolean bl, LocalizedString localizedString2) {
        return (DataShareAuthorizationType)((Object)advice$create.perform((Callable)new DataShareAuthorizationType$callable$create(string, localizedString, string2, bl, localizedString2)));
    }

    static /* synthetic */ DataShareAuthorizationType advised$create(String code, LocalizedString name, String groupExpression, boolean active, LocalizedString question) {
        DataShareAuthorizationType result = new DataShareAuthorizationType();
        result.init(code, name, groupExpression, active, question);
        return result;
    }

    public DataShareAuthorizationType edit(String string, LocalizedString localizedString, String string2, boolean bl, LocalizedString localizedString2) {
        return (DataShareAuthorizationType)((Object)advice$edit.perform((Callable)new DataShareAuthorizationType$callable$edit(this, string, localizedString, string2, bl, localizedString2)));
    }

    static /* synthetic */ DataShareAuthorizationType advised$edit(DataShareAuthorizationType this_, String code, LocalizedString name, String groupExpression, boolean active, LocalizedString question) {
        this_.init(code, name, groupExpression, active, question);
        return this_;
    }

    public static Set<DataShareAuthorizationType> find(String code, String name, String groupExpression, boolean active, String question) {
        Stream universe = Bennu.getInstance().getDataShareAuthorizationTypeSet().stream();
        return universe.filter(i -> StringUtils.isBlank((String)code) || StringUtils.equalsIgnoreCase((String)i.getCode(), (String)code)).filter(i -> StringUtils.isBlank((String)name) || i.getName().anyMatch(c -> c.contains(name))).filter(i -> StringUtils.isBlank((String)groupExpression) || i.getGroupExpression().contains(groupExpression)).filter(i -> StringUtils.isBlank((String)question) || i.getQuestion().anyMatch(c -> c.contains(question))).collect(Collectors.toSet());
    }

    public static DataShareAuthorizationType findUnique(String code) {
        Set<DataShareAuthorizationType> found = DataShareAuthorizationType.find(code, null, null, true, null);
        if (found.size() > 1) {
            throw new AcademicExtensionsDomainException("error.DataShareAuthorizationType.duplicated", new String[0]);
        }
        return found.size() == 1 ? found.iterator().next() : null;
    }

    public boolean isActive() {
        return super.getActive();
    }

    public boolean isRoot() {
        return this.getDataShareAuthorizationTypeParent() == null;
    }
}

