/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.evaluation.markSheet;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheet;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetSnapshot$callable$delete;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetSnapshotEntry;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetSnapshot_Base;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetStateChange;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetStateEnum;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.evaluation.markSheet.MarkBean;
import org.fenixedu.academic.util.FenixDigestUtils;
import org.fenixedu.academicextensions.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.commons.i18n.LocalizedString;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CompetenceCourseMarkSheetSnapshot
extends CompetenceCourseMarkSheetSnapshot_Base {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected CompetenceCourseMarkSheetSnapshot() {
    }

    protected void init(CompetenceCourseMarkSheetStateChange stateChange, String competenceCourseCode, LocalizedString competenceCourseName, String executionSemester, LocalizedString evaluationSeason, String certifier, LocalDate evaluationDate, DateTime evaluationDateTime) {
        this.setStateChange(stateChange);
        this.setCompetenceCourseCode(competenceCourseCode);
        this.setCompetenceCourseName(competenceCourseName);
        this.setExecutionSemester(executionSemester);
        this.setEvaluationSeason(evaluationSeason);
        this.setCertifier(certifier);
        this.setEvaluationDate(evaluationDate);
        this.setEvaluationDateTime(evaluationDateTime);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getStateChange().getState() != CompetenceCourseMarkSheetStateEnum.findSubmited()) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheetSnapshot.stateChange.must.be.of.type.submited", new String[0]);
        }
        if (this.getStateChange() == null) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheetSnapshot.stateChange.required", new String[0]);
        }
        if (this.getCompetenceCourseName() == null || this.getCompetenceCourseName().isEmpty()) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheetSnapshot.competenceCourseName.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)this.getExecutionSemester())) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheetSnapshot.executionSemester.required", new String[0]);
        }
        if (this.getEvaluationSeason() == null || this.getEvaluationSeason().isEmpty()) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheetSnapshot.evaluationSeason.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)this.getCertifier())) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheetSnapshot.certifier.required", new String[0]);
        }
        if (this.getEvaluationDate() == null) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheetSnapshot.evaluationDate.required", new String[0]);
        }
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new CompetenceCourseMarkSheetSnapshot$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(CompetenceCourseMarkSheetSnapshot this_) {
        AcademicExtensionsDomainException.throwWhenDeleteBlocked(this_.getDeletionBlockers());
        Iterator iterator = this_.getEntrySet().iterator();
        while (iterator.hasNext()) {
            CompetenceCourseMarkSheetSnapshotEntry entry = (CompetenceCourseMarkSheetSnapshotEntry)((Object)iterator.next());
            iterator.remove();
            entry.delete();
        }
        super.setStateChange(null);
        this_.deleteDomainObject();
    }

    public void addEntry(Integer studentNumber, String studentName, Grade grade, String degreeCode, LocalizedString degreeName, String shifts) {
        this.getEntrySet().add(CompetenceCourseMarkSheetSnapshotEntry.create(this, studentNumber, studentName, grade, degreeCode, degreeName, shifts));
    }

    public void finalize() {
        this.checkRules();
        if (this.getEntrySet().isEmpty()) {
            throw new AcademicExtensionsDomainException("error.CompetenceCourseMarkSheetSnapshot.entry.required", new String[0]);
        }
        this.updateCheckSum();
    }

    private void updateCheckSum() {
        StringBuilder content = new StringBuilder();
        content.append(this.getCompetenceCourseName().toString());
        content.append(this.getExecutionSemester());
        content.append(this.getEvaluationSeason().toString());
        content.append(this.getCertifier());
        content.append(this.getStateChange().getCompetenceCourseMarkSheet().hasCourseEvaluationDate() ? this.getEvaluationDateTime().toString("yyyy/MM/dd HH:mm") : this.getEvaluationDate().toString("yyyy/MM/dd"));
        content.append(this.getStateChange().getDate().toString("yyyy/MM/dd"));
        for (CompetenceCourseMarkSheetSnapshotEntry entry : this.getSortedEntries()) {
            content.append(entry.getStudentNumber().toString());
            content.append(entry.getStudentName());
            content.append(entry.getGrade().getValue());
        }
        this.setCheckSum(FenixDigestUtils.createDigest((String)content.toString()));
    }

    public SortedSet<CompetenceCourseMarkSheetSnapshotEntry> getSortedEntries() {
        Comparator byStudentName = (x, y) -> CompetenceCourseMarkSheet.COMPARATOR_FOR_STUDENT_NAME.compare(x.getStudentName(), y.getStudentName());
        TreeSet result = Sets.newTreeSet(byStudentName.thenComparing(DomainObjectUtil.COMPARATOR_BY_ID));
        result.addAll(this.getEntrySet());
        return result;
    }

    public static CompetenceCourseMarkSheetSnapshot create(CompetenceCourseMarkSheetStateChange stateChange, String competenceCourseCode, LocalizedString competenceCourseName, String executionSemester, LocalizedString evaluationSeason, String certifier, LocalDate evaluationDate, DateTime evaluationDateTime) {
        CompetenceCourseMarkSheetSnapshot result = new CompetenceCourseMarkSheetSnapshot();
        result.init(stateChange, competenceCourseCode, competenceCourseName, executionSemester, evaluationSeason, certifier, evaluationDate, evaluationDateTime);
        return result;
    }

    public String getFormattedCheckSum() {
        if (StringUtils.isEmpty((String)this.getCheckSum())) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int counter = 0;
        char[] cArray = this.getCheckSum().toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            result.append(c);
            if (++counter % 2 != 0) continue;
            result.append(" ");
        }
        if (result.toString().endsWith(" ")) {
            result.delete(result.length() - 1, result.length());
        }
        return result.toString().toUpperCase();
    }

    public boolean isLastSnapshot() {
        return this.getStateChange().getCompetenceCourseMarkSheet().getLastSnapshot().get() == this;
    }

    public String getEvaluationDatePresentation() {
        DateTime dateTime = CompetenceCourseMarkSheet.getEvaluationDateTime(this.getEvaluationDateTime(), this.getEvaluationDate());
        return CompetenceCourseMarkSheet.getEvaluationDatePresentation(dateTime);
    }

    public List<MarkBean> getDifferencesToNextGradeValues() {
        CompetenceCourseMarkSheetSnapshot next = this.getNextSnapshot();
        return next != null ? this.compare(next) : this.compare(this.getMarkSheet());
    }

    private CompetenceCourseMarkSheetSnapshot getNextSnapshot() {
        List<CompetenceCourseMarkSheetSnapshot> snapshots = this.getMarkSheet().getSnapshots();
        int thisIndex = snapshots.indexOf((Object)this);
        return thisIndex < 0 || thisIndex == snapshots.size() - 1 ? null : snapshots.get(thisIndex + 1);
    }

    private CompetenceCourseMarkSheet getMarkSheet() {
        return this.getStateChange().getCompetenceCourseMarkSheet();
    }

    private List<MarkBean> compare(CompetenceCourseMarkSheetSnapshot other) {
        MarkBean bean;
        ArrayList result = Lists.newArrayList();
        HashSet thisMarks = Sets.newHashSet((Iterable)this.getEntrySet());
        HashSet otherMarks = Sets.newHashSet((Iterable)other.getEntrySet());
        Iterator thisIterator = thisMarks.iterator();
        while (thisIterator.hasNext()) {
            CompetenceCourseMarkSheetSnapshotEntry thisMark = (CompetenceCourseMarkSheetSnapshotEntry)((Object)thisIterator.next());
            Iterator otherIterator = otherMarks.iterator();
            while (otherIterator.hasNext()) {
                CompetenceCourseMarkSheetSnapshotEntry otherMark = (CompetenceCourseMarkSheetSnapshotEntry)((Object)otherIterator.next());
                if (thisMark.getStudentNumber().intValue() != otherMark.getStudentNumber().intValue()) continue;
                thisIterator.remove();
                otherIterator.remove();
                if (otherMark.getGrade().equals(thisMark.getGrade())) continue;
                MarkBean bean2 = new MarkBean();
                bean2.setStudentNumber(otherMark.getStudentNumber());
                bean2.setStudentName(otherMark.getStudentName());
                bean2.setGradeValue(otherMark.getGrade().getValue());
                bean2.setInfoMessage("Nota anterior: " + thisMark.getGrade());
                result.add(bean2);
            }
        }
        for (CompetenceCourseMarkSheetSnapshotEntry thisMark : thisMarks) {
            bean = new MarkBean();
            bean.setStudentNumber(thisMark.getStudentNumber());
            bean.setStudentName(thisMark.getStudentName());
            bean.setInfoMessage("Nota removida: " + thisMark.getGrade());
            result.add(bean);
        }
        for (CompetenceCourseMarkSheetSnapshotEntry otherMark : otherMarks) {
            bean = new MarkBean();
            bean.setStudentNumber(otherMark.getStudentNumber());
            bean.setStudentName(otherMark.getStudentName());
            bean.setGradeValue(otherMark.getGrade().getValue());
            bean.setInfoMessage("Nota adicionada");
            result.add(bean);
        }
        return result;
    }

    private List<MarkBean> compare(CompetenceCourseMarkSheet other) {
        ArrayList result = Lists.newArrayList();
        HashSet thisMarks = Sets.newHashSet((Iterable)this.getEntrySet());
        HashSet otherMarks = Sets.newHashSet((Iterable)other.getEnrolmentEvaluationSet());
        Iterator thisIterator = thisMarks.iterator();
        while (thisIterator.hasNext()) {
            CompetenceCourseMarkSheetSnapshotEntry thisMark = (CompetenceCourseMarkSheetSnapshotEntry)((Object)thisIterator.next());
            Iterator otherIterator = otherMarks.iterator();
            while (otherIterator.hasNext()) {
                EnrolmentEvaluation otherMark = (EnrolmentEvaluation)otherIterator.next();
                Registration registration = otherMark.getRegistration();
                if (thisMark.getStudentNumber().intValue() != registration.getNumber().intValue()) continue;
                thisIterator.remove();
                otherIterator.remove();
                if (otherMark.getGrade().equals(thisMark.getGrade())) continue;
                MarkBean bean = new MarkBean();
                bean.setStudentNumber(registration.getNumber());
                bean.setStudentName(registration.getName());
                bean.setGradeValue(otherMark.getGrade().getValue());
                bean.setInfoMessage("Nota anterior: " + thisMark.getGrade());
                result.add(bean);
            }
        }
        for (CompetenceCourseMarkSheetSnapshotEntry thisMark : thisMarks) {
            MarkBean bean = new MarkBean();
            bean.setStudentNumber(thisMark.getStudentNumber());
            bean.setStudentName(thisMark.getStudentName());
            bean.setInfoMessage("Nota removida: " + thisMark.getGrade());
            result.add(bean);
        }
        for (EnrolmentEvaluation otherMark : otherMarks) {
            Registration registration = otherMark.getRegistration();
            MarkBean bean = new MarkBean();
            bean.setStudentNumber(registration.getNumber());
            bean.setStudentName(registration.getName());
            bean.setGradeValue(otherMark.getGrade().getValue());
            bean.setInfoMessage("Nota adicionada");
            result.add(bean);
        }
        return result;
    }
}

