/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academicextensions.domain.person.dataShare;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academicextensions.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academicextensions.domain.person.dataShare.DataShareAuthorizationChoice$callable$create;
import org.fenixedu.academicextensions.domain.person.dataShare.DataShareAuthorizationChoice$callable$delete;
import org.fenixedu.academicextensions.domain.person.dataShare.DataShareAuthorizationChoice$callable$edit;
import org.fenixedu.academicextensions.domain.person.dataShare.DataShareAuthorizationChoice_Base;
import org.fenixedu.academicextensions.util.AcademicExtensionsUtil;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Deprecated
public class DataShareAuthorizationChoice
extends DataShareAuthorizationChoice_Base {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected DataShareAuthorizationChoice() {
        this.setRoot(Bennu.getInstance());
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new DataShareAuthorizationChoice$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(DataShareAuthorizationChoice this_) {
        this_.setRoot(null);
        AcademicExtensionsDomainException.throwWhenDeleteBlocked(this_.getDeletionBlockers());
        super.deleteDomainObject();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getAuthorizationSet().isEmpty()) {
            blockers.add(AcademicExtensionsUtil.bundle("error.DataShareAuthorizationChoice.has.Authorizations", new String[0]));
        }
        if (!this.getTypeSet().isEmpty()) {
            blockers.add(AcademicExtensionsUtil.bundle("error.DataShareAuthorizationChoice.has.Types", new String[0]));
        }
    }

    protected void init(String code, LocalizedString description, boolean allow, boolean allowComercialUse, boolean allowProfessionalUse) {
        this.setCode(code);
        this.setDescription(description);
        this.setAllow(allow);
        this.setAllowComercialUse(allowComercialUse);
        this.setAllowProfessionalUse(allowProfessionalUse);
        this.checkRules();
    }

    public void checkRules() {
        if (StringUtils.isBlank((String)this.getCode())) {
            throw new AcademicExtensionsDomainException("error.DataShareAuthorizationChoice.code.required", new String[0]);
        }
        if (this.getDescription() == null || this.getDescription().isEmpty()) {
            throw new AcademicExtensionsDomainException("error.DataShareAuthorizationChoice.description.required", new String[0]);
        }
        DataShareAuthorizationChoice.findUnique(this.getCode());
    }

    public static DataShareAuthorizationChoice create(String string, LocalizedString localizedString, boolean bl, boolean bl2, boolean bl3) {
        return (DataShareAuthorizationChoice)((Object)advice$create.perform((Callable)new DataShareAuthorizationChoice$callable$create(string, localizedString, bl, bl2, bl3)));
    }

    static /* synthetic */ DataShareAuthorizationChoice advised$create(String code, LocalizedString description, boolean allow, boolean allowComercialUse, boolean allowProfessionalUse) {
        DataShareAuthorizationChoice result = new DataShareAuthorizationChoice();
        result.init(code, description, allow, allowComercialUse, allowProfessionalUse);
        return result;
    }

    public DataShareAuthorizationChoice edit(String string, LocalizedString localizedString, boolean bl, boolean bl2, boolean bl3) {
        return (DataShareAuthorizationChoice)((Object)advice$edit.perform((Callable)new DataShareAuthorizationChoice$callable$edit(this, string, localizedString, bl, bl2, bl3)));
    }

    static /* synthetic */ DataShareAuthorizationChoice advised$edit(DataShareAuthorizationChoice this_, String code, LocalizedString description, boolean allow, boolean allowComercialUse, boolean allowProfessionalUse) {
        this_.init(code, description, allow, allowComercialUse, allowProfessionalUse);
        return this_;
    }

    public static Set<DataShareAuthorizationChoice> find(String code, String description) {
        Stream universe = Bennu.getInstance().getDataShareAuthorizationChoiceSet().stream();
        return universe.filter(i -> StringUtils.isBlank((String)code) || StringUtils.equalsIgnoreCase((String)i.getCode(), (String)code)).filter(i -> StringUtils.isBlank((String)description) || i.getDescription().anyMatch(c -> c.contains(description))).collect(Collectors.toSet());
    }

    public static DataShareAuthorizationChoice findUnique(String code) {
        Set<DataShareAuthorizationChoice> found = DataShareAuthorizationChoice.find(code, null);
        if (found.size() > 1) {
            throw new AcademicExtensionsDomainException("error.DataShareAuthorizationChoice.duplicated", new String[0]);
        }
        return found.size() == 1 ? found.iterator().next() : null;
    }

    public boolean isAllow() {
        return super.getAllow();
    }

    public boolean isAllowComercialUse() {
        return super.getAllowComercialUse();
    }

    public boolean isAllowProfessionalUse() {
        return super.getAllowProfessionalUse();
    }

    public LocalizedString getFullDescription() {
        LocalizedString result = this.getDescription();
        if (this.isAllow() || !this.isAllowComercialUse() || !this.isAllowProfessionalUse()) {
            result = result.append(" [");
            if (this.isAllow()) {
                result.append(AcademicExtensionsUtil.bundleI18N("label.DataShareAuthorizationChoice.allow", new String[0])).append("; ");
            }
            if (!this.isAllowComercialUse()) {
                result.append(AcademicExtensionsUtil.bundleI18N("label.DataShareAuthorizationChoice.allowComercialUse", new String[0])).append(": ").append(AcademicExtensionsUtil.bundleI18N("label.no", new String[0])).append("; ");
            }
            if (!this.isAllowProfessionalUse()) {
                result.append(AcademicExtensionsUtil.bundleI18N("label.DataShareAuthorizationChoice.allowProfessionalUse", new String[0])).append(": ").append(AcademicExtensionsUtil.bundleI18N("label.no", new String[0])).append("; ");
            }
            result = result.append("]");
        }
        return result;
    }
}

