/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academicextensions.domain.person.dataShare;

import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academicextensions.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academicextensions.domain.person.dataShare.DataShareAuthorizationChoice;
import org.fenixedu.academicextensions.domain.person.dataShare.DataShareAuthorizationType;
import org.fenixedu.academicextensions.domain.person.dataShare.DataShareAuthorization_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.groups.Group;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class DataShareAuthorization
extends DataShareAuthorization_Base {
    protected DataShareAuthorization() {
        this.setRoot(Bennu.getInstance());
    }

    public void delete() {
        this.setRoot(null);
        this.setPerson(null);
        this.setType(null);
        this.setChoice(null);
        AcademicExtensionsDomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        super.deleteDomainObject();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
    }

    protected void init(Person person, DataShareAuthorizationType type, DataShareAuthorizationChoice choice, DateTime since) {
        this.setPerson(person);
        this.setType(type);
        this.setChoice(choice);
        this.setSince(since);
        this.checkRules();
    }

    public void checkRules() {
        if (this.getPerson() == null) {
            throw new AcademicExtensionsDomainException("error.DataShareAuthorization.person.required", new String[0]);
        }
        if (this.getType() == null) {
            throw new AcademicExtensionsDomainException("error.DataShareAuthorization.type.required", new String[0]);
        }
    }

    public static DataShareAuthorization create(Person person, DataShareAuthorizationType type, boolean allow) {
        DataShareAuthorization result = new DataShareAuthorization();
        result.init(person, type, null, new DateTime());
        result.setAllow(allow);
        return result;
    }

    private static Set<DataShareAuthorization> find(Person person, DataShareAuthorizationType type, DateTime when) {
        Stream universe = person != null ? person.getDataShareAuthorizationSet().stream() : (type != null ? type.getAuthorizationSet().stream() : Bennu.getInstance().getDataShareAuthorizationSet().stream());
        return universe.filter(i -> person == null || i.getPerson() == person).filter(i -> type == null || i.getType() == type).filter(i -> when == null || i.getSince().isBefore((ReadableInstant)when)).collect(Collectors.toSet());
    }

    public static DataShareAuthorization findLatest(Person person, DataShareAuthorizationType type) {
        return DataShareAuthorization.find(person, type, null).stream().max(Comparator.comparing(DataShareAuthorization_Base::getSince)).orElse(null);
    }

    public Boolean getAllow() {
        return this.getChoice() != null ? this.getChoice().getAllow() : super.getAllow().booleanValue();
    }

    public void setAllow(Boolean allow) {
        super.setAllow(allow);
        if (Boolean.FALSE.equals(allow) && this.getType().getDataShareAuthorizationTypeParent() != null) {
            DataShareAuthorizationType dataShareAuthorizationTypeParent = this.getType().getDataShareAuthorizationTypeParent();
            Person person = this.getPerson();
            DataShareAuthorization parentAuthorization = DataShareAuthorization.findLatest(person, dataShareAuthorizationTypeParent);
            Optional<DataShareAuthorizationType> anyChildStillAllowed = dataShareAuthorizationTypeParent.getDataShareAuthorizationTypeChildrenSet().stream().filter(x -> x.isActive() && Boolean.TRUE.equals(DataShareAuthorization.findLatest(person, x).getAllow())).findAny();
            if (!anyChildStillAllowed.isPresent()) {
                parentAuthorization.setAllow(false);
            }
        }
    }

    public static boolean isDataShareAllowed(Person person, DataShareAuthorizationType type) {
        DataShareAuthorization authorization = DataShareAuthorization.findLatest(person, type);
        return authorization != null && authorization.getAllow() != null && authorization.getAllow() != false;
    }

    public static Set<DataShareAuthorizationType> findActiveAuthorizationTypes(Person person) {
        return Bennu.getInstance().getDataShareAuthorizationTypeSet().stream().filter(type -> type.isActive() && Group.parse((String)type.getGroupExpression()).isMember(person.getUser())).collect(Collectors.toSet());
    }

    public static Set<DataShareAuthorizationType> findActiveAuthorizationTypesNotAnswered(Person person) {
        return DataShareAuthorization.findActiveAuthorizationTypes(person).stream().filter(type -> DataShareAuthorization.find(person, type, null).isEmpty()).collect(Collectors.toSet());
    }
}

