/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.evaluation.markSheet.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.dto.evaluation.markSheet.report.AbstractSeasonReport;
import org.fenixedu.academic.dto.evaluation.markSheet.report.CompetenceCourseSeasonReport;
import org.joda.time.LocalDate;

public class ExecutionCourseSeasonReport
extends AbstractSeasonReport {
    private ExecutionCourse executionCourse;
    private List<CompetenceCourseSeasonReport> entries = new ArrayList<CompetenceCourseSeasonReport>();

    public ExecutionCourseSeasonReport(ExecutionCourse executionCourse, EvaluationSeason season, LocalDate evaluationDate, Collection<CompetenceCourseSeasonReport> entries) {
        super(season, evaluationDate);
        this.executionCourse = executionCourse;
        this.entries.addAll(entries);
    }

    @Override
    public Collection<Person> getResponsibles() {
        HashSet<Person> result = new HashSet<Person>();
        for (Professorship professorship : this.getExecutionCourse().getProfessorshipsSet()) {
            if (!professorship.isResponsibleFor()) continue;
            result.add(professorship.getPerson());
        }
        return result;
    }

    @Override
    public Integer getNotEvaluatedStudents() {
        int result = 0;
        for (CompetenceCourseSeasonReport entry : this.entries) {
            result += entry.getNotEvaluatedStudents().intValue();
        }
        return result;
    }

    @Override
    public Integer getEvaluatedStudents() {
        int result = 0;
        for (CompetenceCourseSeasonReport entry : this.entries) {
            result += entry.getEvaluatedStudents().intValue();
        }
        return result;
    }

    @Override
    public Integer getMarksheetsTotal() {
        int result = 0;
        for (CompetenceCourseSeasonReport entry : this.entries) {
            result += entry.getMarksheetsTotal().intValue();
        }
        return result;
    }

    @Override
    public Integer getMarksheetsToConfirm() {
        int result = 0;
        for (CompetenceCourseSeasonReport entry : this.entries) {
            result += entry.getMarksheetsToConfirm().intValue();
        }
        return result;
    }

    @Override
    public ExecutionSemester getExecutionSemester() {
        return this.getExecutionCourse().getExecutionPeriod();
    }

    public ExecutionCourse getExecutionCourse() {
        return this.executionCourse;
    }
}

