/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.evaluation.season;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.OccupationPeriod;
import org.fenixedu.academic.domain.OccupationPeriodReference;
import org.fenixedu.academic.domain.OccupationPeriodType;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonPeriod$callable$addDegree;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonPeriod$callable$addInterval;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonPeriod$callable$create;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonPeriod$callable$delete;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonPeriod$callable$removeDegree;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonPeriod$callable$removeInterval;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonPeriod_Base;
import org.fenixedu.academic.domain.executionPlanning.services.OccupationPeriodServices;
import org.fenixedu.academicextensions.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academicextensions.util.AcademicExtensionsUtil;
import org.fenixedu.commons.i18n.LocalizedString;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class EvaluationSeasonPeriod
extends EvaluationSeasonPeriod_Base
implements Comparable<EvaluationSeasonPeriod>,
OccupationPeriodServices.OccupationPeriodPartner {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$addDegree = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$removeDegree = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$addInterval = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$removeInterval = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected EvaluationSeasonPeriod() {
    }

    public static EvaluationSeasonPeriod create(ExecutionSemester executionSemester, EvaluationSeasonPeriodType evaluationSeasonPeriodType, EvaluationSeason evaluationSeason, Set<DegreeType> set, LocalDate localDate, LocalDate localDate2) {
        return (EvaluationSeasonPeriod)advice$create.perform((Callable)new EvaluationSeasonPeriod$callable$create(executionSemester, evaluationSeasonPeriodType, evaluationSeason, set, localDate, localDate2));
    }

    static /* synthetic */ EvaluationSeasonPeriod advised$create(ExecutionSemester executionSemester, EvaluationSeasonPeriodType periodType, EvaluationSeason evaluationSeason, Set<DegreeType> degreeTypes, LocalDate start, LocalDate end) {
        EvaluationSeasonPeriod result = new EvaluationSeasonPeriod();
        result.setExecutionSemester(executionSemester);
        result.setSeason(evaluationSeason);
        result.setOccupationPeriod(OccupationPeriodServices.createOccupationPeriod(result, start, end, result.getInitialExecutionDegrees(degreeTypes), periodType.translate()));
        result.checkRules();
        return result;
    }

    private Set<ExecutionDegree> getInitialExecutionDegrees(Set<DegreeType> degreeTypes) {
        HashSet result = Sets.newHashSet();
        ExecutionYear year = this.getExecutionYear();
        if (year != null && degreeTypes != null && !degreeTypes.isEmpty()) {
            result.addAll(ExecutionDegree.getAllByExecutionYearAndDegreeType((ExecutionYear)year, (DegreeType[])degreeTypes.toArray(new DegreeType[degreeTypes.size()])));
        }
        return result;
    }

    @Override
    public Function<OccupationPeriod, OccupationPeriod> setOccupationPeriod() {
        return occupationPeriod -> {
            this.setOccupationPeriod((OccupationPeriod)occupationPeriod);
            return occupationPeriod;
        };
    }

    @Override
    public Function<OccupationPeriodReference, OccupationPeriodReference> createdReferenceCleanup() {
        return reference -> {
            if (reference != null) {
                reference.getEvaluationSeasonSet().clear();
                reference.addEvaluationSeason(this.getSeason());
            }
            return reference;
        };
    }

    private void checkRules() {
        this.checkConsistencySeason();
    }

    private void checkConsistencySeason() {
        for (OccupationPeriodReference reference : this.getReferences()) {
            for (EvaluationSeason season : reference.getEvaluationSeasonSet()) {
                if (season == this.getSeason()) continue;
                throw new AcademicExtensionsDomainException("error.EvaluationSeasonPeriod.evaluationSeason.inconsistent", new String[0]);
            }
        }
    }

    private void checkDuplicates() {
        for (EvaluationSeasonPeriod iter : EvaluationSeasonPeriod.findBy(this.getExecutionSemester(), this.getPeriodType())) {
            if (iter == this || iter.getSeason() != this.getSeason() || !iter.getOccupationPeriod().isEqualTo(this.getOccupationPeriod())) continue;
            throw new AcademicExtensionsDomainException("error.EvaluationSeasonPeriod.occupationPeriod.duplicate", new String[0]);
        }
    }

    public void addDegree(ExecutionDegree executionDegree) {
        Object object = advice$addDegree.perform((Callable)new EvaluationSeasonPeriod$callable$addDegree(this, executionDegree));
    }

    static /* synthetic */ void advised$addDegree(EvaluationSeasonPeriod this_, ExecutionDegree input) {
        OccupationPeriodServices.addDegree(this_, input);
        this_.checkRules();
    }

    public void removeDegree(ExecutionDegree executionDegree) {
        Object object = advice$removeDegree.perform((Callable)new EvaluationSeasonPeriod$callable$removeDegree(this, executionDegree));
    }

    static /* synthetic */ void advised$removeDegree(EvaluationSeasonPeriod this_, ExecutionDegree input) {
        OccupationPeriodServices.removeDegree(this_, input);
        this_.checkRules();
    }

    public void addInterval(LocalDate localDate, LocalDate localDate2) {
        Object object = advice$addInterval.perform((Callable)new EvaluationSeasonPeriod$callable$addInterval(this, localDate, localDate2));
    }

    static /* synthetic */ void advised$addInterval(EvaluationSeasonPeriod this_, LocalDate start, LocalDate end) {
        OccupationPeriodServices.addInterval(this_, start, end);
        this_.checkRules();
    }

    public void removeInterval(LocalDate localDate, LocalDate localDate2) {
        Object object = advice$removeInterval.perform((Callable)new EvaluationSeasonPeriod$callable$removeInterval(this, localDate, localDate2));
    }

    static /* synthetic */ void advised$removeInterval(EvaluationSeasonPeriod this_, LocalDate start, LocalDate end) {
        OccupationPeriodServices.removeInterval(this_, start, end);
        this_.checkRules();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new EvaluationSeasonPeriod$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(EvaluationSeasonPeriod this_) {
        super.setExecutionSemester(null);
        super.setSeason(null);
        OccupationPeriod occupationPeriod = this_.getOccupationPeriod();
        super.setOccupationPeriod(null);
        OccupationPeriodServices.deleteOccupationPeriod(occupationPeriod);
        AcademicExtensionsDomainException.throwWhenDeleteBlocked(this_.getDeletionBlockers());
        this_.deleteDomainObject();
    }

    public static Set<EvaluationSeasonPeriod> findBy(ExecutionYear executionYear, EvaluationSeasonPeriodType periodType) {
        HashSet result = Sets.newHashSet();
        if (executionYear != null && periodType != null) {
            for (ExecutionSemester semester : executionYear.getExecutionPeriodsSet()) {
                result.addAll(EvaluationSeasonPeriod.findBy(semester, periodType));
            }
        }
        return result;
    }

    public static Set<EvaluationSeasonPeriod> findBy(ExecutionSemester semester, EvaluationSeasonPeriodType periodType) {
        HashSet result = Sets.newHashSet();
        if (semester != null && periodType != null) {
            for (EvaluationSeasonPeriod period : semester.getEvaluationSeasonPeriodSet()) {
                if (period.getPeriodType() != periodType) continue;
                result.add(period);
            }
        }
        return result;
    }

    public static Set<EvaluationSeasonPeriod> findBy(ExecutionYear executionYear) {
        return executionYear != null ? executionYear.getExecutionPeriodsSet().stream().flatMap(es -> es.getEvaluationSeasonPeriodSet().stream()).collect(Collectors.toSet()) : new HashSet<EvaluationSeasonPeriod>();
    }

    public EvaluationSeasonPeriodType getPeriodType() {
        return EvaluationSeasonPeriodType.get(this.getOccupationPeriod());
    }

    private ExecutionYear getExecutionYear() {
        return this.getExecutionSemester().getExecutionYear();
    }

    public static String getIntervalsDescription(Set<EvaluationSeasonPeriod> input) {
        LinkedList intervals = Lists.newLinkedList();
        for (EvaluationSeasonPeriod period : input) {
            intervals.addAll(period.getIntervals());
        }
        return OccupationPeriodServices.getIntervalsDescription(intervals);
    }

    public String getIntervalsDescription() {
        return OccupationPeriodServices.getIntervalsDescription(this.getIntervals());
    }

    @Override
    public int compareTo(EvaluationSeasonPeriod other) {
        OccupationPeriod o1 = this.getOccupationPeriod();
        OccupationPeriod o2 = other.getOccupationPeriod();
        return OccupationPeriodServices.COMPARATOR.compare(o1, o2);
    }

    public String getDegreesDescription() {
        StringBuilder result = new StringBuilder();
        LinkedHashMap mapped = Maps.newLinkedHashMap();
        this.getExecutionDegrees().stream().sorted(ExecutionDegree.EXECUTION_DEGREE_COMPARATORY_BY_DEGREE_TYPE_AND_NAME_AND_EXECUTION_YEAR).forEach(i -> {
            DegreeType key = i.getDegreeType();
            if (!mapped.containsKey(key)) {
                mapped.put(key, Sets.newLinkedHashSet());
            }
            ((Set)mapped.get(key)).add(i);
        });
        Iterator iterator = mapped.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            int size = ((Set)entry.getValue()).size();
            if (size == 0) continue;
            result.append(size);
            result.append(" - ");
            result.append(((DegreeType)entry.getKey()).getName().getContent());
            if (!iterator.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public Set<ExecutionDegree> getExecutionDegrees() {
        return OccupationPeriodServices.getExecutionDegrees(this);
    }

    private Set<OccupationPeriodReference> getReferences() {
        return OccupationPeriodServices.getReferences(this);
    }

    public List<Interval> getIntervals() {
        return OccupationPeriodServices.getIntervals(this);
    }

    public boolean isContainingDate(LocalDate date) {
        return OccupationPeriodServices.isContainingDate(this, date);
    }

    public static enum EvaluationSeasonPeriodType {
        GRADE_SUBMISSION{

            @Override
            protected OccupationPeriodType translate() {
                return OccupationPeriodType.GRADE_SUBMISSION;
            }
        }
        ,
        EXAMS{

            @Override
            protected OccupationPeriodType translate() {
                return OccupationPeriodType.EXAMS;
            }
        };


        public LocalizedString getDescriptionI18N() {
            return AcademicExtensionsUtil.bundleI18N(this.name(), new String[0]);
        }

        protected abstract OccupationPeriodType translate();

        protected static EvaluationSeasonPeriodType get(OccupationPeriod input) {
            switch (((OccupationPeriodReference)input.getExecutionDegreesSet().iterator().next()).getPeriodType()) {
                case EXAMS: 
                case EXAMS_SPECIAL_SEASON: {
                    return EXAMS;
                }
                case GRADE_SUBMISSION: 
                case GRADE_SUBMISSION_SPECIAL_SEASON: {
                    return GRADE_SUBMISSION;
                }
            }
            throw new RuntimeException();
        }
    }
}

