/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.evaluation;

import java.util.Comparator;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EnrolmentEvaluation_Base;
import org.fenixedu.academic.domain.curriculum.EnrollmentState;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonServices;
import pt.ist.fenixframework.core.AbstractDomainObject;

public class EvaluationComparator
implements Comparator<EnrolmentEvaluation> {
    @Override
    public int compare(EnrolmentEvaluation left, EnrolmentEvaluation right) {
        if (EvaluationComparator.isFinalInAnyMarkSheet(left) && !EvaluationComparator.isFinalInAnyMarkSheet(right) && !EvaluationComparator.isSpecialAuthorization(right)) {
            return 1;
        }
        if (!EvaluationComparator.isFinalInAnyMarkSheet(left) && EvaluationComparator.isFinalInAnyMarkSheet(right) && !EvaluationComparator.isSpecialAuthorization(left)) {
            return -1;
        }
        return EvaluationComparator.compareBySpecialAuthorizationAndStateAndGradeAndEvaluationDate(left, right);
    }

    private static int compareBySpecialAuthorizationAndStateAndGradeAndEvaluationDate(EnrolmentEvaluation left, EnrolmentEvaluation right) {
        if (EvaluationComparator.isSpecialAuthorization(left) && !EvaluationComparator.isSpecialAuthorization(right) && !EvaluationComparator.isFinalInAnyMarkSheet(right)) {
            return 1;
        }
        if (!EvaluationComparator.isSpecialAuthorization(left) && EvaluationComparator.isSpecialAuthorization(right) && !EvaluationComparator.isFinalInAnyMarkSheet(left)) {
            return -1;
        }
        return EvaluationComparator.compareByStateAndGradeAndEvaluationDate(left, right);
    }

    private static boolean isFinalInAnyMarkSheet(EnrolmentEvaluation input) {
        return input != null && input.getCompetenceCourseMarkSheet() != null && input.isFinal();
    }

    private static boolean isSpecialAuthorization(EnrolmentEvaluation input) {
        return input != null && input.getEvaluationSeason().isSpecialAuthorization();
    }

    private static int compareByStateAndGradeAndEvaluationDate(EnrolmentEvaluation left, EnrolmentEvaluation right) {
        EnrollmentState leftEnrolmentState = left.getEnrollmentStateByGrade();
        EnrollmentState rightEnrolmentState = right.getEnrollmentStateByGrade();
        if (leftEnrolmentState == EnrollmentState.APROVED && rightEnrolmentState == EnrollmentState.APROVED) {
            return EvaluationComparator.compareByGradeAndEvaluationDate(left, right, true);
        }
        if (leftEnrolmentState == EnrollmentState.APROVED) {
            return 1;
        }
        if (rightEnrolmentState == EnrollmentState.APROVED) {
            return -1;
        }
        return EvaluationComparator.compareByGradeAndEvaluationDate(left, right, false);
    }

    private static int compareByGradeAndEvaluationDate(EnrolmentEvaluation left, EnrolmentEvaluation right, boolean bothApproved) {
        int result = left.getGrade().compareTo(right.getGrade());
        if (result != 0) {
            return result;
        }
        if (bothApproved && (result = Comparator.comparing(EnrolmentEvaluation_Base::getExamDateYearMonthDay).reversed().compare(left, right)) != 0) {
            return result;
        }
        result = EvaluationSeasonServices.SEASON_ORDER_COMPARATOR.compare(left.getEvaluationSeason(), right.getEvaluationSeason());
        if (result != 0) {
            return result;
        }
        result = Comparator.comparing(AbstractDomainObject::getExternalId).reversed().compare(left, right);
        if (result != 0) {
            return result;
        }
        return result;
    }
}

