/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.toolkit.components;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fenixedu.bennu.toolkit.components.Component;
import org.fenixedu.bennu.toolkit.components.ToolkitComponent;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;

@ToolkitComponent(key="youtube", name="YouTube", description="Embed a YouTube Video", category="media", editorFiles={"/bennu-toolkit/js/components/youtube.js"}, viewerFiles={"/bennu-toolkit/img/youtube.png"})
public class YouTubeComponent
extends Component {
    private String getYouTubeId(String url) {
        String pattern = "(?<=watch\\?v=|/videos/|embed\\/)[^#\\&\\?]*";
        Pattern compiledPattern = Pattern.compile(pattern);
        Matcher matcher = compiledPattern.matcher(url);
        if (matcher.find()) {
            return matcher.group();
        }
        return "";
    }

    @Override
    public Element process(Element element) {
        Element iframe = new Element(Tag.valueOf((String)"iframe"), "");
        String width = "560";
        if (!element.attr("data-width").equals("")) {
            width = element.attr("data-width");
        }
        String height = "315";
        if (!element.attr("data-height").equals("")) {
            height = element.attr("data-height");
        }
        iframe.attr("width", width);
        iframe.attr("height", height);
        iframe.attr("src", "https://www.youtube.com/embed/" + this.getYouTubeId(element.attr("data-source")));
        iframe.attr("frameborder", "0");
        return iframe;
    }
}

