/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.toolkit.components;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.fenixedu.bennu.core.rest.BennuRestResource;
import org.fenixedu.bennu.toolkit.components.Component;
import org.fenixedu.bennu.toolkit.components.ToolkitComponent;

@Path(value="/bennu-toolkit/")
public class ToolkitResources
extends BennuRestResource {
    private JsonArray cachedResponse;

    @GET
    @Path(value="components")
    @Produces(value={"application/json"})
    public Response components() throws IOException {
        if (this.cachedResponse == null) {
            this.cachedResponse = new JsonArray();
            for (Component component : Component.getComponents()) {
                JsonObject obj = new JsonObject();
                ToolkitComponent annotation = component.getClass().getAnnotation(ToolkitComponent.class);
                obj.addProperty("key", annotation.key());
                obj.addProperty("name", annotation.name());
                obj.addProperty("description", annotation.description());
                JsonArray array2 = new JsonArray();
                for (String file : annotation.editorFiles()) {
                    JsonPrimitive element = new JsonPrimitive(file);
                    array2.add((JsonElement)element);
                }
                obj.add("files", (JsonElement)array2);
                this.cachedResponse.add((JsonElement)obj);
            }
        }
        return Response.ok((Object)ToolkitResources.toJson((JsonElement)this.cachedResponse)).build();
    }
}

