/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.spring.security;

import javax.servlet.http.HttpServletRequest;
import org.fenixedu.bennu.spring.security.CSRFToken;
import org.fenixedu.bennu.spring.security.CSRFTokenRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component(value="csrf")
public class CSRFTokenBean {
    private final CSRFTokenRepository tokenRepository;

    @Autowired
    public CSRFTokenBean(CSRFTokenRepository tokenRepository) {
        this.tokenRepository = tokenRepository;
    }

    public String getToken() {
        return this.tokenRepository.getToken(CSRFTokenBean.getCurrentRequest()).getToken();
    }

    public String field() {
        CSRFToken token = this.tokenRepository.getToken(CSRFTokenBean.getCurrentRequest());
        return "<input type=\"hidden\" name=\"" + token.getParameterName() + "\" value=\"" + token.getToken() + "\"/>";
    }

    public String getParameterName() {
        return this.tokenRepository.getToken(CSRFTokenBean.getCurrentRequest()).getParameterName();
    }

    public String getHeaderName() {
        return this.tokenRepository.getToken(CSRFTokenBean.getCurrentRequest()).getHeaderName();
    }

    private static HttpServletRequest getCurrentRequest() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        return attributes.getRequest();
    }
}

