/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.spring.portal;

import com.qubit.terra.portal.domain.functionalities.Functionality;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.portal.model.Application;
import org.fenixedu.bennu.portal.model.ApplicationRegistry;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.bennu.spring.portal.PortalHandlerMethod;
import org.fenixedu.bennu.spring.portal.SpringApplication;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.i18n.LocalizedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class PortalHandlerMapping
extends RequestMappingHandlerMapping {
    private static final Logger logger = LoggerFactory.getLogger(PortalHandlerMapping.class);
    private static final String[] EMPTY_ARRAY = new String[0];
    public static final String DELEGATE = "$DELEGATE_TO_PARENT$";
    @Autowired
    private MessageSource messageSource;
    private final Map<Class<?>, org.fenixedu.bennu.portal.model.Functionality> functionalities = new HashMap();
    private final Map<Class<?>, Application> applicationClasses = new HashMap();

    protected void initHandlerMethods() {
        this.registerApplications(this.getApplicationContext().getBeansWithAnnotation(SpringApplication.class).values());
        this.registerFunctionalities(this.getApplicationContext().getBeansWithAnnotation(SpringFunctionality.class).values());
        this.registerLonelyControllers(this.getApplicationContext().getBeansWithAnnotation(BennuSpringController.class).values());
        super.initHandlerMethods();
    }

    private void registerLonelyControllers(Collection<Object> values) {
        for (Object bean : values) {
            Class<?> type = bean.getClass();
            Class<?> functionalityType = ((BennuSpringController)AnnotationUtils.findAnnotation(type, BennuSpringController.class)).value();
            org.fenixedu.bennu.portal.model.Functionality functionality = this.functionalities.get(functionalityType);
            if (functionality == null) {
                throw new Error("Controller " + type.getName() + " declares " + functionalityType.getName() + " as a functionality, but it is not one...");
            }
            this.functionalities.put(type, functionality);
        }
    }

    private void registerApplications(Collection<Object> values) {
        for (Object bean : values) {
            Class<?> type = bean.getClass();
            SpringApplication app = (SpringApplication)AnnotationUtils.findAnnotation(type, SpringApplication.class);
            LocalizedString title = this.getLocalized(app.title());
            Application application = new Application(type.getName(), app.path(), app.group(), title, app.description().equals(DELEGATE) ? title : this.getLocalized(app.description()), app.hint());
            this.applicationClasses.put(type, application);
            ApplicationRegistry.registerApplication((Application)application);
            logger.debug("Registered application for type {}", type);
        }
    }

    private void registerFunctionalities(Collection<Object> values) {
        for (Object bean : values) {
            Class<?> type = bean.getClass();
            SpringFunctionality model = (SpringFunctionality)AnnotationUtils.findAnnotation(type, SpringFunctionality.class);
            RequestMapping mapping = (RequestMapping)AnnotationUtils.findAnnotation(type, RequestMapping.class);
            if (mapping == null) {
                throw new Error("Functionality type " + type.getName() + " does not declare a @RequestMapping!");
            }
            Application app = this.applicationClasses.get(model.app());
            String path = this.extractPath(mapping, type);
            LocalizedString title = this.getLocalized(model.title());
            org.fenixedu.bennu.portal.model.Functionality functionality = new org.fenixedu.bennu.portal.model.Functionality("bennu-spring", "/" + path, path.replace('/', '-'), model.accessGroup().equals(DELEGATE) ? app.getAccessGroup() : model.accessGroup(), title, model.description().equals(DELEGATE) ? title : this.getLocalized(model.description()));
            app.addFunctionality((Functionality)functionality);
            this.functionalities.put(type, functionality);
        }
    }

    private String extractPath(RequestMapping mapping, Class<?> type) {
        if (ObjectUtils.isEmpty((Object[])mapping.value())) {
            throw new Error("Functionality type " + type.getName() + " does not declare any @RequestMapping mappings!");
        }
        String path = mapping.value()[0];
        return path.startsWith("/") ? path.substring(1) : path;
    }

    protected HandlerMethod createHandlerMethod(Object handler, Method method) {
        HandlerMethod handlerMethod = super.createHandlerMethod(handler, method).createWithResolvedBean();
        org.fenixedu.bennu.portal.model.Functionality functionality = this.functionalities.get(handlerMethod.getBeanType());
        return new PortalHandlerMethod(handlerMethod, functionality);
    }

    private LocalizedString getLocalized(String key) {
        LocalizedString.Builder builder = new LocalizedString.Builder();
        for (Locale locale : CoreConfiguration.supportedLocales()) {
            builder.with(locale, this.messageSource.getMessage(key, (Object[])EMPTY_ARRAY, "!!" + key + "!!", locale));
        }
        return builder.build();
    }
}

