/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.spring.portal;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.portal.domain.MenuFunctionality;
import org.fenixedu.bennu.portal.servlet.PortalBackend;
import org.fenixedu.bennu.portal.servlet.SemanticURLHandler;

public class SpringPortalBackend
implements PortalBackend {
    public static final String BACKEND_KEY = "bennu-spring";
    private static final SemanticURLHandler HANDLER = new SemanticURLHandler(){

        public void handleRequest(MenuFunctionality functionality, HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
            RequestDispatcher dispatcher = request.getRequestDispatcher(functionality.getItemKey());
            if (dispatcher != null) {
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            } else {
                response.sendError(404, "No forward url could be processed");
            }
        }
    };

    public SemanticURLHandler getSemanticURLHandler() {
        return HANDLER;
    }

    public boolean requiresServerSideLayout() {
        return true;
    }

    public String getBackendKey() {
        return BACKEND_KEY;
    }
}

