/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.spring.BennuSpringModule;
import org.fenixedu.bennu.spring.DomainObjectConverter;
import org.fenixedu.bennu.spring.I18NBean;
import org.fenixedu.bennu.spring.converters.LocalizedStringConverter;
import org.fenixedu.bennu.spring.converters.UserFromUsernameConverter;
import org.fenixedu.bennu.spring.portal.PortalHandlerInterceptor;
import org.fenixedu.bennu.spring.portal.PortalHandlerMapping;
import org.fenixedu.bennu.spring.resolvers.AuthenticatedUserArgumentResolver;
import org.fenixedu.bennu.spring.resolvers.BennuSpringExceptionResolver;
import org.fenixedu.bennu.spring.security.CSRFInterceptor;
import org.fenixedu.bennu.spring.security.CSRFTokenRepository;
import org.fenixedu.commons.i18n.I18N;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.DefaultServletHandlerConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.servlet.view.JstlView;

@Configuration
@ComponentScan(value={"org.fenixedu.bennu"})
public class BennuSpringConfiguration
extends WebMvcConfigurationSupport
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(BennuSpringConfiguration.class);

    @Bean
    public CoreConfiguration.ConfigurationProperties bennuCoreConfiguration() {
        return CoreConfiguration.getConfiguration();
    }

    @Bean
    public ViewResolver getViewResolver() {
        InternalResourceViewResolver resolver = new InternalResourceViewResolver();
        resolver.setViewClass(JstlView.class);
        resolver.setExposeContextBeansAsAttributes(true);
        resolver.setPrefix("/WEB-INF/");
        resolver.setSuffix(".jsp");
        resolver.setOrder(1000000);
        return resolver;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new CSRFInterceptor(this.csrfTokenRepository()));
        registry.addInterceptor((HandlerInterceptor)new PortalHandlerInterceptor());
    }

    public void configureDefaultServletHandling(DefaultServletHandlerConfigurer configurer) {
        configurer.enable();
    }

    @Bean
    public MessageSource messageSource(ApplicationContext context) {
        ReloadableResourceBundleMessageSource source = new ReloadableResourceBundleMessageSource();
        source.setDefaultEncoding("UTF-8");
        Object[] baseNames = this.getBaseNames(context).toArray(new String[0]);
        logger.debug("Adding basenames by @BennuSpringModule configuration: {}", (Object)Arrays.toString(baseNames));
        source.setBasenames((String[])baseNames);
        source.setCacheSeconds(this.bennuCoreConfiguration().developmentMode() != false ? 1 : -1);
        source.setUseCodeAsDefaultMessage(true);
        return source;
    }

    @Bean
    @Order
    public CSRFTokenRepository csrfTokenRepository() {
        return new CSRFTokenRepository();
    }

    private Set<String> getBaseNames(ApplicationContext context) {
        String[] beanNames;
        HashSet<String> baseNames = new HashSet<String>();
        baseNames.add(this.getBundleBasename("BennuSpringResources"));
        for (String beanName : beanNames = context.getBeanNamesForAnnotation(BennuSpringModule.class)) {
            BennuSpringModule bennuSpringModuleAnnotation = (BennuSpringModule)context.findAnnotationOnBean(beanName, BennuSpringModule.class);
            if (bennuSpringModuleAnnotation == null) continue;
            baseNames.addAll(Arrays.stream(bennuSpringModuleAnnotation.bundles()).map(this::getBundleBasename).collect(Collectors.toSet()));
        }
        return baseNames;
    }

    private String getBundleBasename(String bundle) {
        return "/WEB-INF/resources/" + bundle;
    }

    @Bean
    public I18NBean i18n(MessageSource messageSource) {
        return new I18NBean(messageSource);
    }

    @Bean
    public LocaleResolver localeResolver() {
        return new LocaleResolver(){

            public void setLocale(HttpServletRequest request, HttpServletResponse response, Locale locale) {
                I18N.setLocale((HttpSession)request.getSession(), (Locale)locale);
            }

            public Locale resolveLocale(HttpServletRequest request) {
                return I18N.getLocale();
            }
        };
    }

    public PortalHandlerMapping requestMappingHandlerMapping() {
        PortalHandlerMapping handlerMapping = new PortalHandlerMapping();
        handlerMapping.setOrder(0);
        handlerMapping.setInterceptors(this.getInterceptors());
        handlerMapping.setContentNegotiationManager(this.mvcContentNegotiationManager());
        return handlerMapping;
    }

    @Bean
    public ConversionService conversionService(GenericConversionService service) {
        service.addConverter((GenericConverter)new DomainObjectConverter());
        service.addConverter((GenericConverter)new LocalizedStringConverter());
        service.addConverter((GenericConverter)new UserFromUsernameConverter());
        return service;
    }

    @Bean
    public MultipartResolver multipartResolver() {
        return new StandardServletMultipartResolver();
    }

    public void afterPropertiesSet() throws Exception {
        ArrayList<AuthenticatedUserArgumentResolver> resolvers = new ArrayList<AuthenticatedUserArgumentResolver>();
        resolvers.add(new AuthenticatedUserArgumentResolver());
        resolvers.addAll(this.requestMappingHandlerAdapter().getArgumentResolvers());
        this.requestMappingHandlerAdapter().setArgumentResolvers(resolvers);
    }

    protected void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
        exceptionResolvers.add((HandlerExceptionResolver)new BennuSpringExceptionResolver());
        this.addDefaultHandlerExceptionResolvers(exceptionResolvers);
    }
}

