/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.spring.converters;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.Set;
import org.fenixedu.bennu.core.domain.User;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;

public class UserFromUsernameConverter
implements ConditionalGenericConverter {
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return String.class.equals((Object)sourceType.getType()) && User.class.isAssignableFrom(targetType.getType());
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, User.class));
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (Strings.isNullOrEmpty((String)((String)source))) {
            return null;
        }
        User user = User.findByUsername((String)((String)source));
        if (user != null) {
            return user;
        }
        user = (User)FenixFramework.getDomainObject((String)((String)source));
        if (FenixFramework.isDomainObjectValid((DomainObject)user)) {
            return user;
        }
        return null;
    }
}

