/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.spring.security;

import java.security.SecureRandom;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.fenixedu.bennu.spring.security.CSRFToken;

public class CSRFTokenRepository {
    private static final String CSRF_TOKEN_ATTRIBUTE = CSRFTokenRepository.class.getName() + ".CSRF_TOKEN";
    private final SecureRandom random = new SecureRandom();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSRFToken getToken(HttpServletRequest request) {
        HttpSession session = request.getSession();
        CSRFToken token = (CSRFToken)session.getAttribute(CSRF_TOKEN_ATTRIBUTE);
        if (token == null) {
            HttpSession httpSession = session;
            synchronized (httpSession) {
                token = (CSRFToken)session.getAttribute(CSRF_TOKEN_ATTRIBUTE);
                if (token == null) {
                    token = this.generateNewToken();
                    session.setAttribute(CSRF_TOKEN_ATTRIBUTE, (Object)token);
                }
            }
        }
        return token;
    }

    protected CSRFToken generateNewToken() {
        byte[] bytes = new byte[32];
        this.random.nextBytes(bytes);
        return new CSRFToken(Base64.getUrlEncoder().encodeToString(bytes));
    }
}

