/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.spring.security;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.core.security.SkipCSRF;
import org.fenixedu.bennu.spring.security.CSRFToken;
import org.fenixedu.bennu.spring.security.CSRFTokenRepository;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class CSRFInterceptor
implements HandlerInterceptor {
    private static final Set<String> METHODS_TO_FILTER = ImmutableSet.of((Object)"");
    private final CSRFTokenRepository tokenRepository;

    public CSRFInterceptor(CSRFTokenRepository tokenBean) {
        this.tokenRepository = tokenBean;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        CSRFToken token;
        String tokenValue;
        if (METHODS_TO_FILTER.contains(request.getMethod().toLowerCase()) && this.shouldValidateCSRFToken(handler) && (Strings.isNullOrEmpty((String)(tokenValue = this.findToken(token = this.tokenRepository.getToken(request), request))) || !tokenValue.equals(token.getToken()))) {
            response.sendError(400, "CSRF Token not present or incorrect!");
            return false;
        }
        return true;
    }

    private boolean shouldValidateCSRFToken(Object handler) {
        return !((HandlerMethod)handler).getMethod().isAnnotationPresent(SkipCSRF.class);
    }

    private String findToken(CSRFToken token, HttpServletRequest request) {
        String value = request.getParameter(token.getParameterName());
        if (Strings.isNullOrEmpty((String)value)) {
            value = request.getHeader(token.getHeaderName());
        }
        return value;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

