/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.spring.resolvers;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;

public class BennuSpringExceptionResolver
extends AbstractHandlerExceptionResolver {
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (ex instanceof DomainException) {
            try {
                DomainException domainException = (DomainException)ex;
                response.sendError(domainException.getResponseStatus().getStatusCode(), domainException.getLocalizedMessage());
                return new ModelAndView();
            }
            catch (IOException e) {
                this.logger.warn((Object)"Exception ocurred while handling BennuSpringException", (Throwable)e);
            }
        }
        return null;
    }
}

