/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.spring.portal;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.portal.domain.MenuFunctionality;
import org.fenixedu.bennu.portal.servlet.BennuPortalDispatcher;
import org.fenixedu.bennu.spring.portal.PortalHandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class PortalHandlerInterceptor
implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        PortalHandlerMethod handlerMethod = (PortalHandlerMethod)((Object)handler);
        if (handlerMethod.getFunctionality() == null) {
            return true;
        }
        if (BennuPortalDispatcher.getSelectedFunctionality((HttpServletRequest)request) == null) {
            MenuFunctionality functionality = MenuFunctionality.findFunctionality((String)"bennu-spring", (String)handlerMethod.getFunctionality().getKey());
            if (functionality == null) {
                response.sendError(404, "The selected functionality is not configured");
                return false;
            }
            if (!functionality.isAvailableForCurrentUser()) {
                response.sendError(403);
                return false;
            }
            BennuPortalDispatcher.selectFunctionality((HttpServletRequest)request, (MenuFunctionality)functionality);
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

