/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.scheduler.log;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem;
import org.fenixedu.bennu.scheduler.log.ExecutionLog;
import org.fenixedu.bennu.scheduler.log.ExecutionLogRepository;

public class FileSystemLogRepository
implements ExecutionLogRepository {
    private static final JsonParser parser = new JsonParser();
    private String basePath;
    private final int dispersionFactor;

    public FileSystemLogRepository(String basePath, int dispersionFactor) {
        this.basePath = basePath;
        this.dispersionFactor = dispersionFactor;
    }

    public FileSystemLogRepository(int dispersionFactor) {
        this(SchedulerSystem.getLogsPath(), dispersionFactor);
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Override
    public void update(ExecutionLog log) {
        this.store(log, FileSystemLogRepository.readJson(this.logFileFor(log.getTaskName(), log.getId())).map(obj -> obj.getAsJsonPrimitive("previous")).map(JsonPrimitive::getAsString));
    }

    private void store(ExecutionLog log, Optional<String> previous) {
        JsonObject json = log.json();
        previous.ifPresent(prev -> json.addProperty("previous", prev));
        FileSystemLogRepository.write(this.logFileFor(log.getTaskName(), log.getId()), json.toString().getBytes(StandardCharsets.UTF_8), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newExecution(ExecutionLog log) {
        FileSystemLogRepository fileSystemLogRepository = this;
        synchronized (fileSystemLogRepository) {
            JsonObject json = this.readIndexJson();
            Optional<String> previous = Optional.ofNullable(json.getAsJsonPrimitive(log.getTaskName())).map(JsonPrimitive::getAsString);
            json.addProperty(log.getTaskName(), log.getId());
            this.store(log, previous);
            FileSystemLogRepository.write(this.indexFilePath(), json.toString().getBytes(StandardCharsets.UTF_8), false);
        }
    }

    @Override
    public void appendTaskLog(ExecutionLog log, String text) {
        FileSystemLogRepository.write(this.outputFileFor(log.getTaskName(), log.getId()), text.getBytes(StandardCharsets.UTF_8), true);
    }

    @Override
    public void storeFile(ExecutionLog log, String fileName, byte[] contents, boolean append) {
        FileSystemLogRepository.write(this.fullPathFor(log.getTaskName(), log.getId(), fileName), contents, append);
    }

    @Override
    public Stream<ExecutionLog> latest() {
        return this.readIndexJson().entrySet().stream().map(entry -> this.getLog((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString()).orElse(null)).filter(Objects::nonNull);
    }

    @Override
    public Stream<ExecutionLog> executionsFor(String taskName, Optional<String> start, int max) {
        Optional<JsonObject> optional;
        String id;
        if (start.isPresent()) {
            id = start.get();
        } else {
            JsonObject index = this.readIndexJson();
            if (!index.has(taskName)) {
                return Stream.empty();
            }
            id = index.get(taskName).getAsString();
        }
        ArrayList<ExecutionLog> logs = new ArrayList<ExecutionLog>(Math.min(max, 100));
        while (id != null && max > 0 && (optional = FileSystemLogRepository.readJson(this.logFileFor(taskName, id))).isPresent()) {
            JsonObject json = optional.get();
            id = json.has("previous") ? json.get("previous").getAsString() : null;
            logs.add(new ExecutionLog(json));
            --max;
        }
        return logs.stream();
    }

    @Override
    public Optional<String> getTaskLog(String taskName, String id) {
        return FileSystemLogRepository.read(this.outputFileFor(taskName, id)).map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8));
    }

    @Override
    public Optional<byte[]> getFile(String taskName, String id, String fileName) {
        return FileSystemLogRepository.read(this.fullPathFor(taskName, id, fileName));
    }

    @Override
    public Optional<ExecutionLog> getLog(String taskName, String id) {
        return FileSystemLogRepository.readJson(this.logFileFor(taskName, id)).map(ExecutionLog::new);
    }

    private JsonObject readIndexJson() {
        return FileSystemLogRepository.readJson(this.indexFilePath()).orElseGet(JsonObject::new);
    }

    private String indexFilePath() {
        return this.basePath + "/index.json";
    }

    private String fullPathFor(String taskName, String id, String fileName) {
        return this.basePathFor(taskName, id) + "/files/" + Hashing.sha1().hashString((CharSequence)fileName, StandardCharsets.UTF_8).toString();
    }

    private String logFileFor(String taskName, String id) {
        return this.basePathFor(taskName, id) + "/execution.json";
    }

    private String outputFileFor(String taskName, String id) {
        return this.basePathFor(taskName, id) + "/output";
    }

    private String basePathFor(String taskName, String id) {
        return this.basePath + "/" + taskName.replace('.', '_') + "/" + Joiner.on((char)'/').join(Splitter.fixedLength((int)this.dispersionFactor).split((CharSequence)id));
    }

    private static void write(String path, byte[] bytes, boolean append) {
        File file = new File(path);
        file.getParentFile().mkdirs();
        try (FileOutputStream stream = new FileOutputStream(file, append);){
            stream.write(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Optional<byte[]> read(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return Optional.empty();
        }
        try {
            return Optional.of(Files.toByteArray((File)file));
        }
        catch (IOException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    private static Optional<JsonObject> readJson(String path) {
        Optional<JsonElement> e = FileSystemLogRepository.read(path).map(bytes -> parser.parse(new String((byte[])bytes, StandardCharsets.UTF_8)));
        return e.filter(o -> !o.isJsonNull()).map(JsonElement::getAsJsonObject);
    }
}

