/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.scheduler.log;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.fenixedu.commons.stream.StreamUtils;
import org.joda.time.DateTime;

public class ExecutionLog {
    private final String id;
    private final DateTime start;
    private final Optional<DateTime> end;
    private final TaskState state;
    private final String taskName;
    private final Optional<String> stackTrace;
    private final Set<String> files;
    private final String hostname;
    private final Optional<String> code;
    private final Optional<String> user;

    private static String computeHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "<unknown-host>";
        }
    }

    protected ExecutionLog(JsonObject json) {
        this.id = ExecutionLog.string(json, "id").get();
        this.start = ExecutionLog.string(json, "start").map(DateTime::new).get();
        this.end = ExecutionLog.string(json, "end").map(DateTime::new);
        this.state = ExecutionLog.string(json, "state").map(TaskState::valueOf).get();
        this.taskName = ExecutionLog.string(json, "taskName").get();
        this.stackTrace = ExecutionLog.string(json, "stackTrace");
        this.files = StreamUtils.of((JsonArray)json.getAsJsonArray("files")).map(file -> file.getAsJsonPrimitive().getAsString()).collect(Collectors.toSet());
        this.hostname = ExecutionLog.string(json, "hostname").get();
        this.code = ExecutionLog.string(json, "code");
        this.user = ExecutionLog.string(json, "user");
    }

    private static final Optional<String> string(JsonObject json, String property) {
        return Optional.ofNullable(json.getAsJsonPrimitive(property)).map(JsonPrimitive::getAsString);
    }

    private ExecutionLog(String id, DateTime start, Optional<DateTime> end, TaskState state, String taskName, Optional<String> stackTrace, Set<String> files, String hostname, Optional<String> code, Optional<String> user) {
        this.id = id;
        this.start = start;
        this.end = end;
        this.state = state;
        this.taskName = taskName;
        this.stackTrace = stackTrace;
        this.files = files;
        this.hostname = hostname;
        this.code = code;
        this.user = user;
    }

    public static ExecutionLog newExecutionFor(String taskName) {
        return new ExecutionLog(UUID.randomUUID().toString().replace("-", ""), DateTime.now(), Optional.empty(), TaskState.RUNNING, Objects.requireNonNull(taskName), Optional.empty(), Collections.emptySet(), ExecutionLog.computeHostName(), Optional.empty(), Optional.empty());
    }

    public static ExecutionLog newCustomExecution(String taskName, String code, String user) {
        return new ExecutionLog(UUID.randomUUID().toString().replace("-", ""), DateTime.now(), Optional.empty(), TaskState.RUNNING, Objects.requireNonNull(taskName), Optional.empty(), Collections.emptySet(), ExecutionLog.computeHostName(), Optional.of(code), Optional.of(user));
    }

    public String getId() {
        return this.id;
    }

    public DateTime getStart() {
        return this.start;
    }

    public Optional<DateTime> getEnd() {
        return this.end;
    }

    public TaskState getState() {
        return this.state;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public Optional<String> getStackTrace() {
        return this.stackTrace;
    }

    public Set<String> getFiles() {
        return this.files;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Optional<String> getCode() {
        return this.code;
    }

    public Optional<String> getUser() {
        return this.user;
    }

    public ExecutionLog withSuccess() {
        return new ExecutionLog(this.id, this.start, Optional.of(DateTime.now()), TaskState.SUCCESS, this.taskName, Optional.empty(), this.files, this.hostname, this.code, this.user);
    }

    public ExecutionLog withError(Throwable t) {
        StringWriter stacktrace = new StringWriter();
        try (PrintWriter writer = new PrintWriter(stacktrace);){
            t.printStackTrace(writer);
        }
        return new ExecutionLog(this.id, this.start, Optional.of(DateTime.now()), TaskState.FAILURE, this.taskName, Optional.of(stacktrace.toString()), this.files, this.hostname, this.code, this.user);
    }

    public ExecutionLog withFile(String filename) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this.files);
        builder.add((Object)filename);
        return new ExecutionLog(this.id, this.start, this.end, this.state, this.taskName, this.stackTrace, (Set<String>)builder.build(), this.hostname, this.code, this.user);
    }

    public JsonObject json() {
        JsonObject json = new JsonObject();
        json.addProperty("id", this.id);
        json.addProperty("start", this.start.toString());
        this.end.ifPresent(val -> json.addProperty("end", val.toString()));
        json.addProperty("state", this.state.name());
        json.addProperty("taskName", this.taskName);
        this.stackTrace.ifPresent(val -> json.addProperty("stackTrace", val));
        json.add("files", (JsonElement)this.files.stream().map(JsonPrimitive::new).collect(StreamUtils.toJsonArray()));
        json.addProperty("hostname", this.hostname);
        this.code.ifPresent(val -> json.addProperty("code", val));
        this.user.ifPresent(val -> json.addProperty("user", val));
        return json;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.start, this.end, this.state, this.taskName, this.stackTrace, this.hostname, this.files, this.code, this.user});
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExecutionLog) {
            ExecutionLog other = (ExecutionLog)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals((Object)this.state, (Object)other.state) && Objects.equals(this.taskName, other.taskName) && Objects.equals(this.stackTrace, other.stackTrace) && Objects.equals(this.hostname, other.hostname) && Objects.equals(this.files, other.files) && Objects.equals(this.code, other.code) && Objects.equals(this.user, other.user);
        }
        return false;
    }

    public static enum TaskState {
        RUNNING,
        SUCCESS,
        FAILURE;

    }
}

