/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.scheduler.custom;

import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.scheduler.custom.CustomTask;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassBean
implements Serializable {
    private static final long serialVersionUID = 6558922605683134259L;
    public static final Logger LOGGER = LoggerFactory.getLogger(ClassBean.class);
    private String className;
    private String contents;
    private static final List<Executer> runningExecuters = Collections.synchronizedList(new ArrayList());

    public ClassBean(String className, String contents) {
        this.className = className;
        this.contents = contents.trim();
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getContents() {
        return this.contents;
    }

    public void setContents(String contents) {
        this.contents = contents;
    }

    public static List<Executer> getRunningExecuters() {
        return Collections.unmodifiableList(runningExecuters);
    }

    public void run() {
        Executer executer = new Executer();
        executer.start();
    }

    public JsonObject compile() {
        Executer executer = new Executer();
        return executer.runCompile();
    }

    public class Executer
    extends Thread {
        private final DateTime uploadTime = new DateTime();
        private final Writer out = new StringWriter();
        private final String username = Authenticate.isLogged() ? Authenticate.getUser().getUsername() : null;

        public Executer() {
            runningExecuters.add(this);
        }

        private String getBaseClassPathDirName() {
            String tmpDirName = System.getProperty("java.io.tmpdir");
            return tmpDirName + File.separatorChar + "ClassBean_classpath_" + this.hashCode();
        }

        private String getBaseFileName() {
            String baseClassPathDirName = this.getBaseClassPathDirName();
            String pathFileName = ClassBean.this.className.replace('.', File.separatorChar);
            return baseClassPathDirName + File.separatorChar + pathFileName;
        }

        private String getJavaFileName() {
            return this.getBaseFileName() + ".java";
        }

        private void createDirs() {
            String filename = this.getJavaFileName();
            File file = new File(filename);
            file.getParentFile().mkdirs();
        }

        private Boolean compileFile() throws IOException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, URISyntaxException {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Method method = classLoader.getClass().getMethod("getURLs", new Class[0]);
            URL[] urls = (URL[])method.invoke((Object)classLoader, new Object[0]);
            ArrayList<File> files = new ArrayList<File>();
            for (URL url : urls) {
                files.add(new File(url.toURI()));
            }
            CodeSource servletCodeSource = HttpServletRequest.class.getProtectionDomain().getCodeSource();
            if (servletCodeSource != null && servletCodeSource.getLocation() != null) {
                files.add(new File(servletCodeSource.getLocation().toURI()));
            }
            JavaSourceFromString javaSourceFromString = new JavaSourceFromString(ClassBean.this.getClassName(), ClassBean.this.getContents());
            JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
            try (StandardJavaFileManager standardJavaFileManager = javaCompiler.getStandardFileManager(null, null, null);){
                standardJavaFileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(new File(this.getBaseClassPathDirName())));
                standardJavaFileManager.setLocation(StandardLocation.CLASS_PATH, files);
                ArrayList<JavaSourceFromString> javaFileObjects = new ArrayList<JavaSourceFromString>();
                javaFileObjects.add(javaSourceFromString);
                List<String> options = Arrays.asList("-g");
                JavaCompiler.CompilationTask compilationTask = javaCompiler.getTask(this.out, standardJavaFileManager, null, options, null, javaFileObjects);
                if (!compilationTask.call().booleanValue()) {
                    Boolean bl = false;
                    return bl;
                }
                Boolean bl = true;
                return bl;
            }
        }

        private void runTask() throws ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, IOException {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL[] urls = new URL[]{new File(this.getBaseClassPathDirName()).toURI().toURL()};
            try (MyClassLoader urlClassLoader = new MyClassLoader(urls, classLoader);){
                urlClassLoader.loadClass(ClassBean.this.getClassName());
                Class<?> clazz = Class.forName(ClassBean.this.getClassName(), true, urlClassLoader);
                this.setName("CustomTaskRunner-" + clazz.getName() + "-" + this.uploadTime.getMillis());
                CustomTask task = (CustomTask)clazz.newInstance();
                task.init(ClassBean.this.contents, this.username);
                task.run();
            }
        }

        @Override
        public void run() {
            this.runCompileAndExecute();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runCompileAndExecute() {
            try {
                try {
                    try {
                        this.createDirs();
                        this.compileFile();
                        this.runTask();
                    }
                    catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | URISyntaxException e) {
                        throw new Error(e);
                    }
                }
                finally {
                    this.cleanup();
                }
            }
            finally {
                runningExecuters.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JsonObject runCompile() {
            Boolean compiledSuccessfully = false;
            try {
                this.createDirs();
                compiledSuccessfully = this.compileFile();
            }
            catch (IOException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | URISyntaxException e) {
                try (PrintWriter pout = new PrintWriter(this.out);){
                    e.printStackTrace(pout);
                }
            }
            finally {
                this.cleanup();
            }
            JsonObject result = new JsonObject();
            result.addProperty("compileOK", compiledSuccessfully);
            if (!compiledSuccessfully.booleanValue()) {
                result.addProperty("error", this.out.toString());
            }
            return result;
        }

        private void cleanup() {
            String dirName = this.getBaseClassPathDirName();
            File file = new File(dirName);
            this.delete(file);
        }

        private void delete(File file) {
            if (file.isDirectory()) {
                for (File subFile : file.listFiles()) {
                    this.delete(subFile);
                }
            }
            file.delete();
        }

        public String getClassBeanClassName() {
            return ClassBean.this.getClassName();
        }

        public DateTime getUploaded() {
            return this.uploadTime;
        }
    }

    public static class MyClassLoader
    extends URLClassLoader {
        private final ClassLoader parent;

        public MyClassLoader(URL[] urls, ClassLoader parent) {
            super(urls);
            this.parent = parent;
        }

        @Override
        public synchronized void clearAssertionStatus() {
            this.parent.clearAssertionStatus();
            super.clearAssertionStatus();
        }

        @Override
        public URL getResource(String name) {
            URL url = super.getResource(name);
            return url == null ? this.parent.getResource(name) : url;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            InputStream inputStream = this.parent.getResourceAsStream(name);
            return inputStream == null ? super.getResourceAsStream(name) : inputStream;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            ArrayList<URL> urls = new ArrayList<URL>();
            Enumeration<URL> e = super.getResources(name);
            while (e.hasMoreElements()) {
                urls.add(e.nextElement());
            }
            e = this.parent.getResources(name);
            while (e.hasMoreElements()) {
                urls.add(e.nextElement());
            }
            return Collections.enumeration(urls);
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            try {
                return super.loadClass(name, resolve);
            }
            catch (ClassNotFoundException e) {
                return this.parent.loadClass(name);
            }
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            try {
                return super.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return this.parent.loadClass(name);
            }
        }

        @Override
        public synchronized void setClassAssertionStatus(String className, boolean enabled) {
            this.parent.setClassAssertionStatus(className, enabled);
            super.setClassAssertionStatus(className, enabled);
        }

        @Override
        public synchronized void setDefaultAssertionStatus(boolean enabled) {
            this.parent.setDefaultAssertionStatus(enabled);
            super.setDefaultAssertionStatus(enabled);
        }

        @Override
        public synchronized void setPackageAssertionStatus(String packageName, boolean enabled) {
            this.parent.setPackageAssertionStatus(packageName, enabled);
            super.setPackageAssertionStatus(packageName, enabled);
        }
    }

    public static class JavaSourceFromString
    extends SimpleJavaFileObject {
        final String code;

        JavaSourceFromString(String name, String code) {
            super(URI.create("string:///" + name.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.code = code;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.code;
        }
    }
}

