/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.scheduler.api;

import com.google.gson.JsonElement;
import java.util.Optional;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.rest.BennuRestResource;
import org.fenixedu.bennu.scheduler.api.json.SimpleExecutionLogJsonAdapter;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem;

@Path(value="/bennu-scheduler/log")
public class ExecutionLogResource
extends BennuRestResource {
    @GET
    @Produces(value={"application/json"})
    public JsonElement latest() {
        this.accessControl((Group)Group.managers());
        return this.view(SchedulerSystem.getLogRepository().latest(), SimpleExecutionLogJsonAdapter.class);
    }

    @GET
    @Path(value="{taskName}")
    @Produces(value={"application/json"})
    public JsonElement executionsFor(@PathParam(value="taskName") String taskName, @QueryParam(value="count") @DefaultValue(value="20") int max, @QueryParam(value="start") String start) {
        this.accessControl((Group)Group.managers());
        return this.view(SchedulerSystem.getLogRepository().executionsFor(taskName, Optional.ofNullable(start), max), SimpleExecutionLogJsonAdapter.class);
    }

    @GET
    @Path(value="{taskName}/{id}")
    @Produces(value={"application/json"})
    public JsonElement executionLog(@PathParam(value="taskName") String taskName, @PathParam(value="id") String id) {
        this.accessControl((Group)Group.managers());
        return SchedulerSystem.getLogRepository().getLog(taskName, id).map(arg_0 -> ((ExecutionLogResource)this).view(arg_0)).orElseThrow(() -> new WebApplicationException(Response.Status.NOT_FOUND));
    }

    @GET
    @Path(value="cat/{taskName}/{id}")
    @Produces(value={"text/plain"})
    public String taskLog(@PathParam(value="taskName") String taskName, @PathParam(value="id") String id) {
        this.accessControl((Group)Group.managers());
        return SchedulerSystem.getLogRepository().getTaskLog(taskName, id).orElse("");
    }

    @GET
    @Path(value="{taskName}/{id}/{fileName}")
    @Produces(value={"application/octet-stream"})
    public byte[] downloadFile(@PathParam(value="taskName") String taskName, @PathParam(value="id") String id, @PathParam(value="fileName") String fileName) {
        this.accessControl((Group)Group.managers());
        return SchedulerSystem.getLogRepository().getFile(taskName, id, fileName).orElseThrow(() -> new WebApplicationException(Response.Status.NOT_FOUND));
    }

    @GET
    @Path(value="kill/{taskName}")
    @Produces(value={"application/json"})
    public Response killTask(@PathParam(value="taskName") String taskName) {
        this.accessControl((Group)Group.managers());
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            String name = thread.getName();
            if (!name.contains(taskName)) continue;
            thread.stop();
        }
        return this.ok();
    }
}

