/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.scheduler.example;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import org.fenixedu.bennu.scheduler.CronTask;
import org.fenixedu.bennu.scheduler.annotation.Task;

@Task(englishTitle="This task runs every minutes")
public class ExampleTask
extends CronTask {
    private SecureRandom random = new SecureRandom();

    @Override
    public void runTask() {
        int randInt = this.random.nextInt(100);
        if (randInt > 50) {
            throw new AssertionError("Random Int Exception: " + randInt, new Exception("Just a cause"));
        }
        for (int i = 0; i < 32; ++i) {
            String filename = this.next();
            this.taskLog("Writing number %d to file %s\n", i, filename);
            this.output(filename, new Integer(i).toString().getBytes(StandardCharsets.UTF_8));
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private String next() {
        return new BigInteger(130, this.random).toString(32) + ".txt";
    }
}

