/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.scheduler.api.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.fenixedu.bennu.core.annotation.DefaultJsonAdapter;
import org.fenixedu.bennu.core.domain.exceptions.InvalidJsonException;
import org.fenixedu.bennu.core.json.JsonAdapter;
import org.fenixedu.bennu.core.json.JsonBuilder;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem;
import org.fenixedu.bennu.scheduler.domain.TaskSchedule;

@DefaultJsonAdapter(value=TaskSchedule.class)
public class TaskScheduleJsonAdapter
implements JsonAdapter<TaskSchedule> {
    private static final String TASK_TYPE = "type";
    private static final String TASK_SCHEDULE = "schedule";

    public JsonElement view(TaskSchedule taskSchedule, JsonBuilder ctx) {
        JsonObject obj = new JsonObject();
        obj.addProperty("id", taskSchedule.getExternalId());
        obj.addProperty(TASK_TYPE, taskSchedule.getTaskClassName());
        obj.addProperty("name", taskSchedule.getTask().getLocalizedName());
        obj.addProperty(TASK_SCHEDULE, taskSchedule.getSchedule());
        return obj;
    }

    public TaskSchedule create(JsonElement el, JsonBuilder ctx) {
        JsonObject jsonObject = el.getAsJsonObject();
        if (!jsonObject.has(TASK_TYPE) || !jsonObject.has(TASK_SCHEDULE)) {
            throw new InvalidJsonException(el, new String[]{TASK_TYPE, TASK_SCHEDULE});
        }
        String taskType = jsonObject.get(TASK_TYPE).getAsString();
        String schedule2 = jsonObject.get(TASK_SCHEDULE).getAsString();
        return new TaskSchedule(taskType, schedule2);
    }

    public TaskSchedule update(JsonElement el, TaskSchedule taskSchedule, JsonBuilder ctx) {
        JsonObject jsonObject = el.getAsJsonObject();
        String taskType = null;
        String schedule2 = null;
        if (jsonObject.has(TASK_TYPE)) {
            taskType = jsonObject.get(TASK_TYPE).getAsString();
        }
        if (jsonObject.has(TASK_SCHEDULE)) {
            schedule2 = jsonObject.get(TASK_SCHEDULE).getAsString();
        }
        this.updateTaskSchedule(taskSchedule, taskType, schedule2);
        return taskSchedule;
    }

    private void updateTaskSchedule(TaskSchedule taskSchedule, String taskType, String schedule2) {
        SchedulerSystem.unschedule(taskSchedule);
        if (schedule2 != null && !schedule2.equals(taskSchedule.getSchedule())) {
            taskSchedule.setSchedule(schedule2);
        }
        if (taskType != null && !taskType.equals(taskSchedule.getTaskClassName())) {
            taskSchedule.setTaskClassName(taskType);
        }
        SchedulerSystem.schedule(taskSchedule);
    }
}

