/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.scheduler.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.rest.BennuRestResource;
import org.fenixedu.bennu.scheduler.annotation.Task;
import org.fenixedu.bennu.scheduler.api.TaskResource$callable$createRunOnceTaskSchedule;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem;
import org.fenixedu.bennu.scheduler.domain.TaskSchedule;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Path(value="/bennu-scheduler/tasks")
public class TaskResource
extends BennuRestResource {
    public static final Advice advice$createRunOnceTaskSchedule = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    @GET
    @Produces(value={"application/json"})
    public JsonObject getTasks() {
        this.accessControl((Group)Group.managers());
        JsonObject objContainer = new JsonObject();
        JsonArray tasks = new JsonArray();
        for (Map.Entry<String, Task> taskEntry : SchedulerSystem.getTasks().entrySet()) {
            JsonObject taskJson = new JsonObject();
            taskJson.addProperty("type", taskEntry.getKey());
            taskJson.addProperty("name", taskEntry.getValue().englishTitle());
            tasks.add((JsonElement)taskJson);
        }
        objContainer.add("tasks", (JsonElement)tasks);
        return objContainer;
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{name}")
    public Response runTaskNow(@PathParam(value="name") String name) {
        this.accessControl((Group)Group.managers());
        try {
            this.createRunOnceTaskSchedule(name);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        return this.ok();
    }

    private TaskSchedule createRunOnceTaskSchedule(String string) {
        return (TaskSchedule)((Object)advice$createRunOnceTaskSchedule.perform((Callable)new TaskResource$callable$createRunOnceTaskSchedule(this, string)));
    }

    static /* synthetic */ TaskSchedule advised$createRunOnceTaskSchedule(TaskResource this_, String name) {
        TaskSchedule taskSchedule = new TaskSchedule(name, Boolean.TRUE);
        return taskSchedule;
    }
}

