/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.scheduler;

import com.google.common.base.Joiner;
import java.util.concurrent.Callable;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.scheduler.annotation.Task;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem;
import org.fenixedu.bennu.scheduler.log.ExecutionLog;
import org.fenixedu.commons.StringNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;

public abstract class CronTask
implements Runnable {
    private Logger logger;
    protected transient ExecutionLog log;
    private final Atomic atomic = new AtomicInstance(this.getTxMode(), true);

    protected Atomic.TxMode getTxMode() {
        Task annotation = this.getClass().getAnnotation(Task.class);
        return annotation == null || annotation.readOnly() ? Atomic.TxMode.READ : Atomic.TxMode.WRITE;
    }

    public String getLocalizedName() {
        return SchedulerSystem.getTaskName(this.getClassName());
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger((String)this.getClassName());
        }
        return this.logger;
    }

    public abstract void runTask() throws Exception;

    @Override
    public final void run() {
        this.log = this.createExecutionLog();
        SchedulerSystem.getLogRepository().newExecution(this.log);
        try {
            this.innerAtomicRun();
            this.updateLog(this.log.withSuccess());
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.updateLog(this.log.withError(t));
        }
        finally {
            this.resetLoggers();
            Authenticate.unmock();
        }
    }

    protected ExecutionLog createExecutionLog() {
        return ExecutionLog.newExecutionFor(this.getClassName());
    }

    private void resetLoggers() {
        this.logger = null;
        this.log = null;
    }

    private void innerAtomicRun() throws Exception {
        FenixFramework.getTransactionManager().withTransaction((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                CronTask.this.runTask();
                return null;
            }
        }, this.atomic);
    }

    private String sanitize(String filename) {
        int i = filename.lastIndexOf(".");
        if (i != -1) {
            return Joiner.on((String)".").join((Object)StringNormalizer.slugify((String)filename.substring(0, i)), (Object)StringNormalizer.slugify((String)filename.substring(i + 1, filename.length())), new Object[0]);
        }
        return filename;
    }

    public void output(String filename, byte[] fileContent, boolean append) {
        String sanitized = this.sanitize(filename);
        SchedulerSystem.getLogRepository().storeFile(this.log, sanitized, fileContent, append);
        this.updateLog(this.log.withFile(sanitized));
    }

    public void output(String filename, byte[] fileContent) {
        this.output(filename, fileContent, false);
    }

    protected final void taskLog(String format, Object ... args) {
        if (args == null || args.length < 1) {
            SchedulerSystem.getLogRepository().appendTaskLog(this.log, format + "\n");
        } else {
            SchedulerSystem.getLogRepository().appendTaskLog(this.log, String.format(format, args));
        }
    }

    protected final void taskLog() {
        this.taskLog("", new Object[0]);
    }

    private void updateLog(ExecutionLog log) {
        this.log = log;
        SchedulerSystem.getLogRepository().update(log);
    }
}

