/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.scheduler.domain;

import com.google.common.io.Files;
import it.sauronsoftware.cron4j.Scheduler;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.io.domain.FileStorage;
import org.fenixedu.bennu.scheduler.SchedulerConfiguration;
import org.fenixedu.bennu.scheduler.TaskRunner;
import org.fenixedu.bennu.scheduler.annotation.Task;
import org.fenixedu.bennu.scheduler.domain.ProcessQueue;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem$1$callable$run;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem$2$callable$lease;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem$3$callable$run;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem$5$callable$run;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem$callable$cleanNonExistingSchedules;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem$callable$getLogsPath;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem$callable$initSchedules;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem$callable$initialize;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem$callable$queue;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem$callable$resetLease;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem$callable$runNow;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem$callable$schedule;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem$callable$shouldRun;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem_Base;
import org.fenixedu.bennu.scheduler.domain.TaskSchedule;
import org.fenixedu.bennu.scheduler.log.ExecutionLogRepository;
import org.fenixedu.bennu.scheduler.log.FileSystemLogRepository;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SchedulerSystem
extends SchedulerSystem_Base {
    private static final Logger LOG;
    private static final Map<String, Task> tasks;
    private static Scheduler scheduler;
    public static LinkedBlockingQueue<TaskRunner> queue;
    public static Set<TaskRunner> runningTasks;
    public static Set<TaskSchedule> scheduledTasks;
    private static Set<Timer> timers;
    private static DateTime latestOwnedLease;
    private static ExecutionLogRepository repository;
    private static ThreadPoolExecutor taskPool;
    private static transient Integer leaseTime;
    private static transient Integer queueThreadsNumber;
    public static final Advice advice$initialize;
    public static final Advice advice$shouldRun;
    public static final Advice advice$cleanNonExistingSchedules;
    public static final Advice advice$initSchedules;
    public static final Advice advice$schedule;
    public static final Advice advice$runNow;
    public static final Advice advice$resetLease;
    public static final Advice advice$getLogsPath;
    public static final Advice advice$queue;

    private static Integer getLeaseTimeMinutes() {
        if (leaseTime == null) {
            Integer leaseTimeProperty = SchedulerConfiguration.getConfiguration().leaseTimeMinutes();
            if (leaseTimeProperty < 2) {
                throw new Error("property scheduler.lease.time.minutes must be a positive integer greater than 1.");
            }
            leaseTime = leaseTimeProperty;
        }
        return leaseTime;
    }

    private static Integer getQueueThreadsNumber() {
        if (queueThreadsNumber == null) {
            Integer queueThreadsNumberProperty = SchedulerConfiguration.getConfiguration().queueThreadsNumber();
            if (queueThreadsNumberProperty < 1) {
                throw new Error("property scheduler.queue.threads.number must be a positive integer greater than 0.");
            }
            queueThreadsNumber = queueThreadsNumberProperty;
        }
        return queueThreadsNumber;
    }

    private SchedulerSystem() {
        this.setBennu(Bennu.getInstance());
        File tmp = Files.createTempDir();
        this.setLoggingStorage(FileStorage.createNewFileSystemStorage((String)"schedulerSystemLoggingStorage", (String)tmp.getAbsolutePath(), (Integer)0));
        LOG.info("Create sensible default {} for logging storage", (Object)tmp.getAbsolutePath());
    }

    public static SchedulerSystem getInstance() {
        if (Bennu.getInstance().getSchedulerSystem() == null) {
            return SchedulerSystem.initialize();
        }
        return Bennu.getInstance().getSchedulerSystem();
    }

    private static SchedulerSystem initialize() {
        return (SchedulerSystem)((Object)advice$initialize.perform((Callable)new SchedulerSystem$callable$initialize()));
    }

    static /* synthetic */ SchedulerSystem advised$initialize() {
        if (Bennu.getInstance().getSchedulerSystem() == null) {
            return new SchedulerSystem();
        }
        return Bennu.getInstance().getSchedulerSystem();
    }

    public Set<TaskSchedule> getTaskScheduleSet() {
        return super.getTaskScheduleSet();
    }

    public static Boolean isRunning() {
        return SchedulerSystem.isActive() != false && scheduler.isStarted();
    }

    public static Boolean isActive() {
        return scheduler != null;
    }

    private Boolean shouldRun() {
        return (Boolean)advice$shouldRun.perform((Callable)new SchedulerSystem$callable$shouldRun(this));
    }

    static /* synthetic */ Boolean advised$shouldRun(SchedulerSystem this_) {
        if (this_.isLeaseExpired()) {
            this_.lease();
            return true;
        }
        return false;
    }

    private DateTime lease() {
        DateTime lease2 = new DateTime().withMillisOfSecond(0);
        this.setLease(lease2);
        latestOwnedLease = lease2;
        return lease2;
    }

    private boolean isHoldingLease() {
        DateTime lease2 = this.getLease();
        return lease2 != null && lease2.equals((Object)latestOwnedLease) && lease2.plusMinutes(SchedulerSystem.getLeaseTimeMinutes().intValue()).isAfterNow();
    }

    private boolean isLeaseExpired() {
        DateTime lease2 = this.getLease();
        if (lease2 == null) {
            return true;
        }
        return lease2.plusMinutes(SchedulerSystem.getLeaseTimeMinutes().intValue()).isBeforeNow();
    }

    public static void init() {
        Timer waitingForLeaseTimer = new Timer("waitingForLeaseTimer", true);
        waitingForLeaseTimer.scheduleAtFixedRate(new TimerTask(){
            Boolean shouldRun = false;
            public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));

            @Override
            public void run() {
                Object object = advice$run.perform((Callable)new SchedulerSystem$1$callable$run(this));
            }

            static /* synthetic */ void advised$run(1 this_) {
                this_.setShouldRun(SchedulerSystem.getInstance().shouldRun());
                if (this_.shouldRun.booleanValue()) {
                    SchedulerSystem.bootstrap();
                } else {
                    LOG.debug("Lease is not gone. Wait for it ...");
                }
                this_.setShouldRun(false);
            }

            public void setShouldRun(Boolean shouldRun2) {
                this.shouldRun = shouldRun2;
            }
        }, 0L, (long)(SchedulerSystem.getLeaseTimeMinutes() * 60 * 1000));
        timers.add(waitingForLeaseTimer);
    }

    private static synchronized void bootstrap() {
        LOG.info("Running Scheduler bootstrap");
        if (scheduler == null) {
            scheduler = new Scheduler();
            scheduler.setDaemon(true);
        }
        if (!scheduler.isStarted()) {
            SchedulerSystem.cleanNonExistingSchedules();
            SchedulerSystem.initSchedules();
            SchedulerSystem.spawnConsumers();
            SchedulerSystem.spawnRefreshSchedulesTask();
            SchedulerSystem.spawnLeaseTimerTask();
            scheduler.start();
        }
    }

    private static void spawnLeaseTimerTask() {
        int period = SchedulerSystem.getLeaseTimeMinutes() * 60 * 1000 / 2;
        Timer leaseTimer = new Timer("leaseTimer", true);
        leaseTimer.scheduleAtFixedRate(new TimerTask(){
            public static final Advice advice$lease = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

            @Override
            public void run() {
                if (SchedulerSystem.isRunning().booleanValue()) {
                    this.lease();
                }
            }

            private void lease() {
                Object object = advice$lease.perform((Callable)new SchedulerSystem$2$callable$lease(this));
            }

            static /* synthetic */ void advised$lease(2 this_) {
                if (SchedulerSystem.getInstance().isHoldingLease()) {
                    DateTime lease2 = SchedulerSystem.getInstance().lease();
                    LOG.debug("Leasing until {}", (Object)lease2);
                } else {
                    LOG.debug("Lost lease, stopping the scheduler");
                    SchedulerSystem.destroy(false);
                    SchedulerSystem.init();
                }
            }
        }, 0L, (long)period);
        timers.add(leaseTimer);
    }

    private static void spawnRefreshSchedulesTask() {
        Timer refreshSchedulesTimer = new Timer("refreshSchedulesTimer", true);
        refreshSchedulesTimer.scheduleAtFixedRate(new TimerTask(){
            public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));

            @Override
            public void run() {
                Object object = advice$run.perform((Callable)new SchedulerSystem$3$callable$run(this));
            }

            static /* synthetic */ void advised$run(3 this_) {
                LOG.debug("Running refresh schedules");
                HashSet<TaskSchedule> domainSchedules = new HashSet<TaskSchedule>(SchedulerSystem.getInstance().getTaskScheduleSet());
                for (TaskSchedule schedule2 : domainSchedules) {
                    if (schedule2.isScheduled().booleanValue()) continue;
                    LOG.debug("New schedule not scheduled before {} {}", (Object)schedule2.getExternalId(), (Object)schedule2.getTaskClassName());
                    SchedulerSystem.schedule(schedule2);
                }
                for (TaskSchedule schedule2 : scheduledTasks) {
                    if (domainSchedules.contains((Object)schedule2)) continue;
                    LOG.debug("schedule disappeared not unscheduled before {} {}", (Object)schedule2.getExternalId());
                    SchedulerSystem.unschedule(schedule2);
                }
                LOG.debug("Refresh schedules done");
            }
        }, 0L, 60000L);
        timers.add(refreshSchedulesTimer);
    }

    private static void spawnConsumers() {
        int threadsNumber = SchedulerSystem.getQueueThreadsNumber();
        ThreadFactory taskThreadFactory = new ThreadFactory(){
            private final ThreadFactory factory = Executors.defaultThreadFactory();
            private int counter = 0;

            @Override
            public Thread newThread(Runnable r) {
                Thread taskThread = this.factory.newThread(r);
                ++this.counter;
                taskThread.setName("SchedulerConsumer-" + this.counter);
                return taskThread;
            }
        };
        taskPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(threadsNumber, taskThreadFactory);
        for (int i = 0; i < threadsNumber; ++i) {
            LOG.debug("Launching queue consumer {}", (Object)(i + 1));
            taskPool.execute(new ProcessQueue());
        }
    }

    private static void cleanNonExistingSchedules() {
        Object object = advice$cleanNonExistingSchedules.perform((Callable)new SchedulerSystem$callable$cleanNonExistingSchedules());
    }

    static /* synthetic */ void advised$cleanNonExistingSchedules() {
        HashSet<TaskSchedule> scheduleSet = new HashSet<TaskSchedule>(SchedulerSystem.getInstance().getTaskScheduleSet());
        for (TaskSchedule schedule2 : scheduleSet) {
            if (tasks.containsKey(schedule2.getTaskClassName())) continue;
            LOG.warn("Class {} is no longer available. schedule {} - {} - {} deleted. ", new Object[]{schedule2.getTaskClassName(), schedule2.getExternalId(), schedule2.getTaskClassName(), schedule2.getSchedule()});
            schedule2.delete(false);
        }
    }

    private static void initSchedules() {
        Object object = advice$initSchedules.perform((Callable)new SchedulerSystem$callable$initSchedules());
    }

    static /* synthetic */ void advised$initSchedules() {
        for (TaskSchedule schedule2 : SchedulerSystem.getInstance().getTaskScheduleSet()) {
            SchedulerSystem.schedule(schedule2);
        }
    }

    public static void schedule(TaskSchedule taskSchedule) {
        Object object = advice$schedule.perform((Callable)new SchedulerSystem$callable$schedule(taskSchedule));
    }

    static /* synthetic */ void advised$schedule(final TaskSchedule schedule2) {
        if (SchedulerSystem.isActive().booleanValue()) {
            if (schedule2.isRunOnce().booleanValue()) {
                SchedulerSystem.runNow(schedule2);
            } else {
                LOG.debug("schedule [{}] {}", (Object)schedule2.getSchedule(), (Object)schedule2.getTaskClassName());
                schedule2.setTaskId(scheduler.schedule(schedule2.getSchedule(), new Runnable(){
                    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));

                    @Override
                    public void run() {
                        Object object = advice$run.perform((Callable)new SchedulerSystem$5$callable$run(this));
                    }

                    static /* synthetic */ void advised$run(5 this_) {
                        if (FenixFramework.isDomainObjectValid((DomainObject)this_.schedule2)) {
                            TaskRunner taskRunner = this_.schedule2.getTaskRunner();
                            SchedulerSystem.queue(taskRunner);
                        }
                    }
                }));
                scheduledTasks.add(schedule2);
            }
        } else {
            LOG.debug("don't schedule [{}] {}", (Object)schedule2.getSchedule(), (Object)schedule2.getTaskClassName());
        }
    }

    public static void unschedule(TaskSchedule schedule2) {
        if (SchedulerSystem.isActive().booleanValue()) {
            if (schedule2.isRunOnce().booleanValue()) {
                LOG.debug("unschedule run once {}. delete it.", (Object)schedule2.getTaskClassName());
                schedule2.delete(false);
            } else {
                LOG.debug("unschedule [{}] {}", (Object)schedule2.getSchedule(), (Object)schedule2.getTaskClassName());
                scheduler.deschedule(schedule2.getTaskId());
                scheduledTasks.remove((Object)schedule2);
            }
        } else {
            LOG.debug("don't unschedule [{}] {}", (Object)schedule2.getSchedule(), (Object)schedule2.getTaskClassName());
        }
    }

    private static void runNow(TaskSchedule taskSchedule) {
        Object object = advice$runNow.perform((Callable)new SchedulerSystem$callable$runNow(taskSchedule));
    }

    static /* synthetic */ void advised$runNow(TaskSchedule schedule2) {
        LOG.debug("run once schedule {}", (Object)schedule2.getTaskClassName());
        SchedulerSystem.queue(schedule2.getTaskRunner());
        SchedulerSystem.unschedule(schedule2);
    }

    public static final void addTask(String className, Task taskAnnotation) {
        LOG.debug("Register Task : {} with name {}", (Object)className, (Object)taskAnnotation.englishTitle());
        tasks.put(className, taskAnnotation);
    }

    private static void resetLease() {
        Object object = advice$resetLease.perform((Callable)new SchedulerSystem$callable$resetLease());
    }

    static /* synthetic */ void advised$resetLease() {
        LOG.debug("Reset lease to null");
        SchedulerSystem.getInstance().setLease(null);
    }

    public static void destroy() {
        SchedulerSystem.destroy(true);
    }

    private static void destroy(boolean resetLease2) {
        for (Timer timer : timers) {
            LOG.debug("interrupted timer thread {}", (Object)timer.toString());
            timer.cancel();
        }
        queue.clear();
        latestOwnedLease = null;
        if (SchedulerSystem.isActive().booleanValue()) {
            LOG.info("stopping scheduler");
            scheduler.stop();
            taskPool.shutdown();
            if (resetLease2) {
                SchedulerSystem.resetLease();
            }
        }
    }

    public static Map<String, Task> getTasks() {
        return tasks;
    }

    public static String getTaskName(String className) {
        Task taskAnnotation = tasks.get(className);
        if (taskAnnotation != null) {
            return taskAnnotation.englishTitle();
        }
        return null;
    }

    public static String getLogsPath() {
        return (String)advice$getLogsPath.perform((Callable)new SchedulerSystem$callable$getLogsPath());
    }

    static /* synthetic */ String advised$getLogsPath() {
        if (SchedulerSystem.getInstance().getLoggingStorage() == null) {
            throw new Error("Please add logging storage");
        }
        return SchedulerSystem.getInstance().getLoggingStorage().getAbsolutePath();
    }

    public static void queue(TaskRunner taskRunner) {
        Object object = advice$queue.perform((Callable)new SchedulerSystem$callable$queue(taskRunner));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void advised$queue(TaskRunner taskRunner) {
        LinkedBlockingQueue<TaskRunner> linkedBlockingQueue = queue;
        synchronized (linkedBlockingQueue) {
            if (!queue.contains(taskRunner)) {
                if (!runningTasks.contains(taskRunner)) {
                    LOG.debug("Add to queue {}", (Object)taskRunner.getTaskName());
                    try {
                        queue.put(taskRunner);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Thread was interrupted.");
                        Thread.currentThread().interrupt();
                    }
                } else {
                    LOG.debug("Don't add to queue. Task is running {}", (Object)taskRunner.getTaskName());
                }
            } else {
                LOG.debug("Don't add to queue. Already exists {}", (Object)taskRunner.getTaskName());
            }
        }
    }

    public static void setLogRepository(ExecutionLogRepository repo) {
        repository = Objects.requireNonNull(repo);
    }

    public static ExecutionLogRepository getLogRepository() {
        if (repository == null) {
            repository = new FileSystemLogRepository(3);
        }
        return repository;
    }

    static {
        advice$initialize = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        advice$shouldRun = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        advice$cleanNonExistingSchedules = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        advice$initSchedules = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$schedule = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$runNow = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        advice$resetLease = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        advice$getLogsPath = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$queue = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        LOG = LoggerFactory.getLogger(SchedulerSystem.class);
        tasks = new HashMap<String, Task>();
        repository = null;
        queue = new LinkedBlockingQueue();
        timers = new HashSet<Timer>();
        runningTasks = Collections.newSetFromMap(new ConcurrentHashMap());
        scheduledTasks = Collections.newSetFromMap(new ConcurrentHashMap());
        SchedulerSystem.getLeaseTimeMinutes();
        SchedulerSystem.getQueueThreadsNumber();
    }
}

