/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.scheduler.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.rest.BennuRestResource;
import org.fenixedu.bennu.scheduler.api.ScheduleResource$callable$clearAllSchedules;
import org.fenixedu.bennu.scheduler.api.ScheduleResource$callable$createSchedulesFromDump;
import org.fenixedu.bennu.scheduler.api.json.TaskScheduleJsonAdapter;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem;
import org.fenixedu.bennu.scheduler.domain.TaskSchedule;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Path(value="/bennu-scheduler/schedule")
public class ScheduleResource
extends BennuRestResource {
    public static final Advice advice$createSchedulesFromDump = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$clearAllSchedules = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    @GET
    @Produces(value={"application/json"})
    public JsonElement getSchedule() {
        this.accessControl((Group)Group.managers());
        return this.view(SchedulerSystem.getInstance().getTaskScheduleSet(), "schedule");
    }

    @GET
    @Path(value="dump")
    public Response dump() {
        this.accessControl((Group)Group.managers());
        String filename = ScheduleResource.class.getSimpleName() + "_" + new DateTime().toString("MM-dd-yyyy-kk-mm-ss") + ".json";
        return Response.ok((Object)this.view(SchedulerSystem.getInstance().getTaskScheduleSet(), "schedule")).header("Content-Disposition", (Object)("attachment; filename=" + filename)).build();
    }

    @DELETE
    public Response delete() {
        this.accessControl((Group)Group.managers());
        this.clearAllSchedules();
        return this.ok();
    }

    @POST
    @Deprecated
    @Path(value="dump")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response loadDump(@FormParam(value="data") JsonObject json) {
        this.accessControl((Group)Group.managers());
        this.clearAllSchedules();
        this.createSchedulesFromDump(json);
        return this.ok();
    }

    @POST
    @Path(value="load-dump")
    @Consumes(value={"application/json"})
    public JsonElement loadDumpNew(JsonObject json) {
        this.accessControl((Group)Group.managers());
        this.clearAllSchedules();
        this.createSchedulesFromDump(json);
        return this.getSchedule();
    }

    public void createSchedulesFromDump(JsonObject jsonObject) {
        Object object = advice$createSchedulesFromDump.perform((Callable)new ScheduleResource$callable$createSchedulesFromDump(this, jsonObject));
    }

    static /* synthetic */ void advised$createSchedulesFromDump(ScheduleResource this_, JsonObject json) {
        TaskScheduleJsonAdapter taskScheduleJsonAdapter = new TaskScheduleJsonAdapter();
        for (JsonElement schedule2 : json.get("schedule").getAsJsonArray()) {
            taskScheduleJsonAdapter.create(schedule2, null);
        }
    }

    public void clearAllSchedules() {
        Object object = advice$clearAllSchedules.perform((Callable)new ScheduleResource$callable$clearAllSchedules(this));
    }

    static /* synthetic */ void advised$clearAllSchedules(ScheduleResource this_) {
        for (TaskSchedule schedule2 : SchedulerSystem.getInstance().getTaskScheduleSet()) {
            schedule2.delete();
        }
    }

    @GET
    @Path(value="{oid}")
    @Produces(value={"application/json"})
    public JsonElement get(@PathParam(value="oid") String taskOid) {
        this.accessControl((Group)Group.managers());
        return this.view(this.readDomainObject(taskOid));
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JsonElement addSchedule(JsonElement configJson) {
        this.accessControl((Group)Group.managers());
        return this.view(this.create(configJson, TaskSchedule.class));
    }

    @PUT
    @Path(value="{oid}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JsonElement changeSchedule(JsonElement taskScheduleJson, @PathParam(value="oid") String taskScheduleOid) {
        this.accessControl((Group)Group.managers());
        return this.view(this.update(taskScheduleJson, this.readDomainObject(taskScheduleOid)));
    }

    @DELETE
    @Path(value="{oid}")
    public Response delete(@PathParam(value="oid") String taskOid) {
        this.accessControl((Group)Group.managers());
        TaskSchedule schedule2 = (TaskSchedule)this.readDomainObject(taskOid);
        schedule2.delete();
        return this.ok();
    }
}

