/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.scheduler;

import com.google.common.base.Objects;
import org.fenixedu.bennu.scheduler.CronTask;

public class TaskRunner
implements Runnable {
    CronTask task;
    String taskId;

    public TaskRunner(String cronTaskClassName) throws Exception {
        Class<?> taskClass = Class.forName(cronTaskClassName);
        this.task = (CronTask)taskClass.newInstance();
        this.setTaskId(null);
    }

    public TaskRunner(CronTask task) {
        this.task = task;
        this.setTaskId(null);
    }

    @Override
    public void run() {
        this.task.run();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TaskRunner) {
            return ((TaskRunner)obj).getTaskName().equals(this.getTaskName());
        }
        return false;
    }

    public String getTaskName() {
        return this.task.getClass().getName();
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public CronTask getTask() {
        return this.task;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getTaskName()});
    }
}

