/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.validators;

import com.google.common.base.Strings;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;
import pt.ist.fenixWebFramework.renderers.validators.HtmlValidator;

public class NumberValidator
extends HtmlValidator {
    private int base;

    public NumberValidator() {
        this.setBase(10);
    }

    public NumberValidator(HtmlChainValidator htmlChainValidator) {
        super(htmlChainValidator);
        this.setBase(10);
    }

    public NumberValidator(HtmlChainValidator htmlChainValidator, int base) {
        this(htmlChainValidator);
        this.setBase(base);
    }

    public int getBase() {
        return this.base;
    }

    public void setBase(int base) {
        this.base = base;
    }

    @Override
    public String getErrorMessage() {
        return RenderUtils.getResourceString("renderers.validator.number");
    }

    @Override
    public void performValidation() {
        String numberText = this.getComponent().getValue();
        if (!Strings.isNullOrEmpty((String)numberText)) {
            try {
                Integer.parseInt(numberText.trim(), this.getBase());
                this.setValid(true);
            }
            catch (NumberFormatException e) {
                this.setValid(false);
            }
        }
    }

    @Override
    public boolean hasJavascriptSupport() {
        return true;
    }

    @Override
    protected String getSpecificValidatorScript() {
        return "function(element) { var text = $(element).attr('value');return text.length == 0 || text.search(/^[0-9]+$/) == 0; }";
    }
}

