/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.validators;

import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;
import pt.ist.fenixWebFramework.renderers.validators.RegexpValidator;

public class ISSNValidator
extends RegexpValidator {
    private boolean required;

    public ISSNValidator() {
        super("[0-9]{4}-[0-9]{3}[0-9X]");
        this.setMessage("renderers.validator.issn");
        this.setKey(true);
        this.setRequired(false);
    }

    public ISSNValidator(HtmlChainValidator htmlChainValidator) {
        super(htmlChainValidator, "[0-9]{4}-[0-9]{3}[0-9X]");
        this.setMessage("renderers.validator.issn");
        this.setKey(true);
        this.setRequired(false);
    }

    @Override
    public void performValidation() {
        if (this.hasValue()) {
            super.performValidation();
            if (this.isValid()) {
                this.setValid(this.isCheckSumValid(this.getComponent().getValue()));
            }
        } else {
            this.setValid(!this.isRequired());
        }
    }

    private boolean isCheckSumValid(String value) {
        value = value.replaceAll("-", "");
        int res = 0;
        for (int i = 0; i < 7; ++i) {
            res += (8 - i) * (value.charAt(i) - 48);
        }
        int remainder = res % 11;
        int checkDigit = 11 - remainder;
        char result = remainder == 0 ? (char)'0' : (checkDigit == 10 ? (char)'X' : (char)(checkDigit + 48));
        return value.charAt(7) == result;
    }

    private boolean hasValue() {
        return this.getComponent().getValue() != null && this.getComponent().getValue().length() > 0;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }
}

