/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.validators;

import pt.ist.fenixWebFramework.renderers.components.HtmlFormComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlScript;
import pt.ist.fenixWebFramework.renderers.components.Validatable;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.renderers.validators.AbstractHtmlValidator;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;

public abstract class HtmlValidator
extends AbstractHtmlValidator {
    private HtmlChainValidator htmlChainValidator;
    private String message;
    private boolean isKey;
    private String bundle;
    private String clearHandler;
    private String errorHandler;

    protected HtmlValidator() {
        this.setKey(true);
        this.setBundle("RENDERER_RESOURCES");
    }

    public HtmlValidator(HtmlChainValidator htmlChainValidator) {
        this();
        htmlChainValidator.addValidator(this);
        this.htmlChainValidator = htmlChainValidator;
    }

    @Override
    public Validatable getComponent() {
        return this.htmlChainValidator.getComponent();
    }

    public String getClearHandler() {
        return this.clearHandler;
    }

    public void setClearHandler(String clearHandler) {
        this.clearHandler = clearHandler;
    }

    public String getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(String errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getErrorMessage() {
        if (this.isKey()) {
            String errorMessage = this.getResourceMessage(this.getMessage());
            if (errorMessage != null) {
                return errorMessage;
            }
            return this.getMessage();
        }
        return this.getMessage();
    }

    protected String getResourceMessage(String message) {
        return RenderUtils.getResourceString(this.getBundle(), message);
    }

    protected void setHtmlChainValidator(HtmlChainValidator htmlChainValidator) {
        this.htmlChainValidator = htmlChainValidator;
    }

    @Override
    public boolean isKey() {
        return this.isKey;
    }

    public void setKey(boolean isKey) {
        this.isKey = isKey;
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public boolean hasJavascriptSupport() {
        return false;
    }

    public HtmlScript bindJavascript(HtmlFormComponent formComponent) {
        HtmlScript script = new HtmlScript();
        String escapeId = this.getValidatableId(formComponent);
        String bindTo = this.bindJavascriptEventsTo(formComponent);
        script.setScript("$(\"#" + escapeId + "\").validate({ " + (String)(bindTo != null ? "bindEventsTo: \"" + bindTo + "\"," : "") + "validationHandler: " + this.getSpecificValidatorScript() + ", errorMessage: \"" + this.getJavascriptErrorMessage() + "\"" + (String)(this.getClearHandler() != null ? ", clearHandler: " + this.getClearHandler() : "") + (String)(this.getErrorHandler() != null ? ", errorHandler: " + this.getErrorHandler() : "") + "});");
        return script;
    }

    protected String getValidatableId(HtmlFormComponent formComponent) {
        return RenderUtils.escapeId(formComponent.getId());
    }

    protected String getSpecificValidatorScript() {
        return "";
    }

    protected String getJavascriptErrorMessage() {
        return this.getErrorMessage();
    }

    protected String bindJavascriptEventsTo(HtmlFormComponent formComponent) {
        return null;
    }
}

