/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.validators;

import java.util.ArrayList;
import java.util.List;
import pt.ist.fenixWebFramework.renderers.components.Validatable;
import pt.ist.fenixWebFramework.renderers.validators.AbstractHtmlValidator;
import pt.ist.fenixWebFramework.renderers.validators.HtmlValidator;

public class HtmlChainValidator
extends AbstractHtmlValidator {
    private Validatable component;
    private List<HtmlValidator> validators;
    private HtmlValidator failedHtmlValidator;

    public HtmlChainValidator(Validatable component) {
        this.component = component;
        this.validators = new ArrayList<HtmlValidator>();
        component.setChainValidator(this);
    }

    public HtmlChainValidator(Validatable component, List<HtmlValidator> validators) {
        this(component);
        for (HtmlValidator htmlValidator : validators) {
            this.addValidator(htmlValidator);
        }
    }

    @Override
    public void performValidation() {
        for (HtmlValidator htmlValidator : this.validators) {
            htmlValidator.performValidation();
            if (htmlValidator.isValid()) continue;
            this.setValid(false);
            this.failedHtmlValidator = htmlValidator;
            break;
        }
    }

    @Override
    public Validatable getComponent() {
        return this.component;
    }

    public void addValidator(HtmlValidator htmlValidator) {
        this.validators.add(htmlValidator);
        htmlValidator.setHtmlChainValidator(this);
    }

    public void addValidator(HtmlChainValidator htmlChainValidator) {
        if (htmlChainValidator != null && htmlChainValidator != this) {
            for (HtmlValidator htmlValidator : htmlChainValidator.validators) {
                this.addValidator(htmlValidator);
            }
        }
    }

    public boolean isEmpty() {
        return this.validators.isEmpty();
    }

    @Override
    public boolean isKey() {
        return this.failedHtmlValidator != null ? this.failedHtmlValidator.isKey() : false;
    }

    @Override
    public String getErrorMessage() {
        return this.failedHtmlValidator != null ? this.failedHtmlValidator.getErrorMessage() : "";
    }

    @Override
    public String getMessage() {
        return this.failedHtmlValidator != null ? this.failedHtmlValidator.getMessage() : "";
    }

    public List<HtmlValidator> getSupportedJavascriptValidators() {
        ArrayList<HtmlValidator> validators = new ArrayList<HtmlValidator>();
        for (HtmlValidator validator : this.validators) {
            if (!validator.hasJavascriptSupport()) continue;
            validators.add(validator);
        }
        return validators;
    }
}

