/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.validators;

import pt.ist.fenixWebFramework.renderers.components.HtmlInputFile;
import pt.ist.fenixWebFramework.renderers.plugin.RenderersRequestProcessorImpl;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;
import pt.ist.fenixWebFramework.renderers.validators.HtmlValidator;
import pt.ist.fenixWebFramework.servlets.commons.UploadedFile;

public class FileValidator
extends HtmlValidator {
    private boolean required;
    private String maxSize;
    private String acceptedExtensions;
    private String acceptedTypes;
    private String typeMessage;
    private String extensionMessage;
    private String sizeMessage;
    private String bundle;
    private Object[] arguments;

    public FileValidator() {
        this.setTypeMessage("renderers.validator.file.type");
        this.setExtensionMessage("renderers.validator.file.extension");
        this.setSizeMessage("renderers.validator.file.size");
    }

    public FileValidator(HtmlChainValidator htmlChainValidator) {
        super(htmlChainValidator);
        this.setTypeMessage("renderers.validator.file.type");
        this.setExtensionMessage("renderers.validator.file.extension");
        this.setSizeMessage("renderers.validator.file.size");
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getAcceptedExtensions() {
        return this.acceptedExtensions;
    }

    public void setAcceptedExtensions(String acceptedExtensions) {
        this.acceptedExtensions = acceptedExtensions.toLowerCase();
    }

    public String getAcceptedTypes() {
        return this.acceptedTypes != null ? this.acceptedTypes.toLowerCase() : null;
    }

    public void setAcceptedTypes(String acceptedTypes) {
        this.acceptedTypes = acceptedTypes;
    }

    public String getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(String maxSize) {
        this.maxSize = maxSize;
    }

    public String getExtensionMessage() {
        return this.extensionMessage;
    }

    public void setExtensionMessage(String extensionMessage) {
        this.extensionMessage = extensionMessage;
    }

    public String getSizeMessage() {
        return this.sizeMessage;
    }

    public void setSizeMessage(String sizeMessage) {
        this.sizeMessage = sizeMessage;
    }

    public String getTypeMessage() {
        return this.typeMessage;
    }

    public void setTypeMessage(String typeMessage) {
        this.typeMessage = typeMessage;
    }

    @Override
    public String getBundle() {
        return this.bundle;
    }

    @Override
    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    private long convertedMaxSize() {
        long value;
        String maxSize = this.getMaxSize().trim().toLowerCase();
        long multiplier = 1L;
        if (maxSize.matches("[0-9]+(m|k)?b")) {
            int index = maxSize.indexOf("mb");
            if (index != -1) {
                multiplier = 0x100000L;
            } else {
                index = maxSize.indexOf("kb");
                if (index != -1) {
                    multiplier = 1024L;
                } else {
                    index = maxSize.indexOf("b");
                }
            }
            value = Long.parseLong(maxSize.substring(0, index));
        } else {
            value = Long.parseLong(maxSize);
        }
        return value * multiplier;
    }

    @Override
    protected String getResourceMessage(String message) {
        if (this.arguments == null || this.arguments.length == 0) {
            return RenderUtils.getResourceString(this.getBundle(), message);
        }
        return RenderUtils.getFormatedResourceString(this.getBundle(), message, this.arguments);
    }

    @Override
    public void performValidation() {
        String fileName;
        int index;
        long maxSize;
        long size;
        HtmlInputFile fileField = (HtmlInputFile)this.getComponent();
        UploadedFile file = RenderersRequestProcessorImpl.getUploadedFile(fileField.getName());
        if (file == null && this.isRequired()) {
            this.setInvalid("renderers.validator.required", new Object[0]);
            return;
        }
        if (file == null) {
            return;
        }
        if (this.getMaxSize() != null && (size = file.getSize()) > (maxSize = this.convertedMaxSize())) {
            this.setInvalid(this.getSizeMessage(), maxSize, this.getMaxSize());
            return;
        }
        if (this.getAcceptedExtensions() != null && (index = (fileName = file.getName()).lastIndexOf(".")) != -1) {
            String extension = fileName.substring(index + 1).toLowerCase();
            if (!this.getAcceptedExtensions().contains(extension)) {
                this.setInvalid(this.getExtensionMessage(), this.getAcceptedExtensions(), extension);
                return;
            }
            this.setValid(true);
            return;
        }
        if (this.getAcceptedTypes() != null && !this.matchesMimeType(file.getContentType().toLowerCase())) {
            String typesFormated = this.getAcceptedTypes().replace(",", ", ");
            this.setInvalid(this.getTypeMessage(), typesFormated, file.getContentType());
            return;
        }
        this.setValid(true);
    }

    private boolean matchesMimeType(String contentType) {
        String[] acceptedTypes;
        for (String acceptedType : acceptedTypes = this.getAcceptedTypes().split(",")) {
            String accepted = acceptedType;
            if (accepted.contains("*")) {
                accepted = accepted.replace("*", ".*");
            }
            if (!contentType.matches(accepted)) continue;
            return true;
        }
        return false;
    }

    private void setInvalid(String message, Object ... args) {
        this.setMessage(message);
        this.arguments = args;
        this.setValid(false);
    }
}

