/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.validators;

import com.google.common.base.Strings;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;
import pt.ist.fenixWebFramework.renderers.validators.HtmlValidator;

public class DateValidator
extends HtmlValidator {
    private String dateFormat;

    public DateValidator() {
        this.setDateFormat("dd/MM/yyyy");
        this.setKey(true);
    }

    public DateValidator(HtmlChainValidator htmlChainValidator) {
        this(htmlChainValidator, "dd/MM/yyyy");
    }

    public DateValidator(HtmlChainValidator htmlChainValidator, String dateFormat) {
        super(htmlChainValidator);
        this.setDateFormat(dateFormat);
        this.setKey(true);
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Override
    public void performValidation() {
        String text = this.getComponent().getValue();
        if (!Strings.isNullOrEmpty((String)text)) {
            this.setValid(this.isValid(text, this.getDateFormat()));
        }
        if (!this.isValid()) {
            this.setMessage("renderers.validator.date");
        }
    }

    public boolean isValid(String value, String datePattern) {
        if (value == null || datePattern == null || datePattern.length() <= 0) {
            return false;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(datePattern);
        formatter.setLenient(false);
        try {
            formatter.parse(value);
        }
        catch (ParseException e) {
            return false;
        }
        return datePattern.length() == value.length();
    }
}

