/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.utils;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class ClassHierarchyTable<T>
extends ConcurrentHashMap<Class, T> {
    private final List<Class> classSort = new ArrayList<Class>();

    @Override
    public T get(Object key) {
        return this.get(key, t -> true);
    }

    public T get(Object key, Predicate<T> predicate) {
        Class objectType = (Class)key;
        for (Class type : this.classSort) {
            if (!type.isAssignableFrom(objectType) || !predicate.apply(super.get(type))) continue;
            return (T)super.get(type);
        }
        return null;
    }

    public T getUnspecific(Class key) {
        return (T)super.get(key);
    }

    @Override
    public T put(Class key, T value) {
        this.addType(key);
        return super.put(key, value);
    }

    public int addType(Class type) {
        int index = this.findIndex(type);
        this.addType(type, index);
        return index;
    }

    public int findIndex(Class type) {
        int index = 0;
        for (Class element : this.classSort) {
            if (element.isAssignableFrom(type)) break;
            ++index;
        }
        return index;
    }

    private void addType(Class type, int index) {
        if (this.classSort.size() == 0) {
            this.classSort.add(type);
            return;
        }
        if (index == this.classSort.size()) {
            this.classSort.add(index, type);
            return;
        }
        if (!this.classSort.get(index).equals(type)) {
            this.classSort.add(index, type);
        }
    }
}

