/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.taglib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixWebFramework.renderers.schemas.SchemaSlotDescription;
import pt.ist.fenixWebFramework.renderers.taglib.PropertyContainerTag;
import pt.ist.fenixWebFramework.renderers.taglib.SchemaConfigTag;
import pt.ist.fenixWebFramework.renderers.taglib.ValidatorContainerTag;
import pt.ist.fenixWebFramework.renderers.validators.HtmlValidator;
import pt.ist.fenixWebFramework.renderers.validators.RequiredValidator;
import pt.ist.fenixWebFramework.renderers.validators.ValidatorProperties;

public class SchemaSlotConfigTag
extends BodyTagSupport
implements PropertyContainerTag,
ValidatorContainerTag {
    private static final Logger logger = LoggerFactory.getLogger(SchemaSlotConfigTag.class);
    private String name;
    private String bundle;
    private String key;
    private String arg0;
    private String validator;
    private boolean readOnly;
    private boolean required = false;
    private String layout;
    private String help;
    private SchemaConfigTag schemaTag;
    private Map<String, Properties> validators;
    private Properties properties;

    public int doStartTag() throws JspException {
        this.validators = new HashMap<String, Properties>();
        this.properties = new Properties();
        this.schemaTag = (SchemaConfigTag)SchemaSlotConfigTag.findAncestorWithClass((Tag)this, SchemaConfigTag.class);
        if (this.schemaTag == null) {
            throw new RuntimeException("Slot tag can only be used inside a schema tag");
        }
        return super.doStartTag();
    }

    public int doEndTag() throws JspException {
        SchemaSlotDescription slot = new SchemaSlotDescription(this.getName());
        slot.setBundle(this.getBundle());
        slot.setKey(this.getKey());
        slot.setArg0(this.getArg0());
        slot.setArg0(this.getArg0());
        slot.setReadOnly(this.isReadOnly());
        slot.setHelpLabel(this.getHelp());
        slot.setLayout(this.getLayout());
        if (this.validator != null) {
            this.addValidator(this.validator);
        }
        if (this.isRequired()) {
            this.validators.put(RequiredValidator.class.getName(), new Properties());
        }
        slot.setValidators(this.getValidatorsClass());
        SchemaConfigTag parent = (SchemaConfigTag)SchemaSlotConfigTag.findAncestorWithClass((Tag)this, SchemaConfigTag.class);
        parent.addSlots(slot);
        slot.setProperties(this.properties);
        this.release();
        return super.doEndTag();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBundle() {
        return this.bundle == null ? this.schemaTag.getBundle() : this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValidator() {
        return this.validator;
    }

    public void setValidator(String validator) {
        this.validator = validator;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public void release() {
        this.validators = null;
        this.properties = null;
        this.required = false;
        super.release();
    }

    @Override
    public void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    @Override
    public void addValidator(String validatorClassName) {
        this.validators.put(validatorClassName, new Properties());
    }

    @Override
    public void addValidatorProperty(String validatorClassName, String propertyName, String propertyValue) {
        this.validators.get(validatorClassName).setProperty(propertyName, propertyValue);
    }

    protected List<ValidatorProperties> getValidatorsClass() {
        ArrayList<ValidatorProperties> res = new ArrayList<ValidatorProperties>();
        for (Map.Entry<String, Properties> entry : this.validators.entrySet()) {
            try {
                Class<HtmlValidator> validatorClass = Class.forName(entry.getKey());
                res.add(new ValidatorProperties(validatorClass, entry.getValue()));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("specified validator does not exist: " + entry.getKey(), e);
            }
        }
        return res;
    }

    public String getArg0() {
        return this.arg0;
    }

    public void setArg0(String arg0) {
        this.arg0 = arg0;
    }
}

