/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.taglib;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import org.apache.commons.beanutils.ConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectFactory;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;
import pt.ist.fenixWebFramework.renderers.schemas.Schema;
import pt.ist.fenixWebFramework.renderers.schemas.SchemaSlotDescription;
import pt.ist.fenixWebFramework.renderers.taglib.ContextTag;
import pt.ist.fenixWebFramework.renderers.taglib.EditObjectTag;

public class CreateObjectTag
extends EditObjectTag {
    private static final Logger logger = LoggerFactory.getLogger(CreateObjectTag.class);
    private List<DefaultValue> defaultValues = new ArrayList<DefaultValue>();

    @Override
    public void release() {
        super.release();
        this.defaultValues = new ArrayList<DefaultValue>();
    }

    @Override
    protected MetaObject getNewMetaObject(Object targetObject, Schema schema) {
        ContextTag parent = (ContextTag)CreateObjectTag.findAncestorWithClass((Tag)this, ContextTag.class);
        if (parent == null || this.getSlot() == null) {
            return MetaObjectFactory.createObject((Class)targetObject, schema);
        }
        MetaObject metaObject = parent.getMetaObject();
        if (metaObject == null) {
            metaObject = MetaObjectFactory.createObject((Class)targetObject, schema);
            parent.setMetaObject(metaObject);
        } else {
            SchemaSlotDescription slotDescription = schema.getSlotDescription(this.getSlot());
            if (slotDescription != null) {
                MetaSlot slot = MetaObjectFactory.createSlot(metaObject, slotDescription);
                metaObject.addSlot(slot);
            }
        }
        return metaObject;
    }

    @Override
    protected Object getTargetObject() throws JspException {
        if (this.isPostBack()) {
            return this.getViewState().getMetaObject().getType();
        }
        try {
            return Class.forName(this.getType());
        }
        catch (ClassNotFoundException e) {
            throw new JspException("could not get class named " + this.getType(), (Throwable)e);
        }
    }

    @Override
    protected MetaObject createMetaObject(Object targetObject, Schema schema) {
        MetaObject metaObject = super.createMetaObject(targetObject, schema);
        if (this.getSlot() != null && metaObject instanceof MetaSlot) {
            MetaSlot slot = (MetaSlot)metaObject;
            for (DefaultValue defaultValue : this.defaultValues) {
                if (!slot.getName().equals(defaultValue.getSlot())) continue;
                Object value = this.getConvertedValue(slot, defaultValue.getConverter(), defaultValue.getValue());
                slot.setObject(value);
            }
        } else {
            for (DefaultValue defaultValue : this.defaultValues) {
                for (MetaSlot slot : metaObject.getSlots()) {
                    if (!slot.getName().equals(defaultValue.getSlot())) continue;
                    Object value = this.getConvertedValue(slot, defaultValue.getConverter(), defaultValue.getValue());
                    slot.setObject(value);
                }
            }
        }
        return metaObject;
    }

    private Object getConvertedValue(MetaSlot slot, Class<Converter> converterClass, Object value) {
        Class type = slot.getStaticType();
        if (converterClass == null) {
            if (value == null) {
                return null;
            }
            if (type.isAssignableFrom(value.getClass())) {
                return value;
            }
            if (value instanceof String) {
                return ConvertUtils.convert((String)((String)value), (Class)type);
            }
            throw new RuntimeException("no converter given and default value '" + value + "' does not match type '" + type + "' of slot '" + slot.getName() + "'");
        }
        try {
            Converter converter = converterClass.newInstance();
            return converter.convert(type, value);
        }
        catch (Exception e) {
            throw new RuntimeException("could not convert default value '" + value + "' using converter '" + converterClass + "'", e);
        }
    }

    public void setDefaultValue(String slot, Object value, Class<Converter> converter) {
        this.defaultValues.add(new DefaultValue(slot, value, converter));
    }

    private static class DefaultValue {
        private String slot;
        private Object value;
        private Class<Converter> converter;

        public DefaultValue(String slot, Object value, Class<Converter> converter) {
            this.slot = slot;
            this.value = value;
            this.converter = converter;
        }

        public Class<Converter> getConverter() {
            return this.converter;
        }

        public String getSlot() {
            return this.slot;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

