/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.model;

import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectKey;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;
import pt.ist.fenixWebFramework.renderers.utils.RendererPropertyUtils;

public class TransientMetaObject
extends MetaObject {
    private transient Object object;
    private Class<?> type;
    private int code;

    public TransientMetaObject(Object object) {
        this.setObject(object);
    }

    protected void setObject(Object object) {
        this.object = object;
        this.code = object == null ? 0 : object.hashCode();
        this.type = object.getClass();
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public MetaObjectKey getKey() {
        return new MetaObjectKey(this.getType(), String.valueOf(this.code));
    }

    @Override
    protected void commit() {
        for (MetaSlot slot : this.getAllSlots()) {
            if (slot.isSetterIgnored() || !slot.isCached()) continue;
            Object value = slot.getObject();
            try {
                this.setProperty(slot, value);
            }
            catch (Exception e) {
                throw new RuntimeException("could not write property '" + slot.getName() + "' in object " + this.getObject(), e);
            }
        }
    }

    protected void setProperty(MetaSlot slot, Object value) {
        RendererPropertyUtils.setProperty(this.getObject(), slot.getName(), value, false);
    }
}

