/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.model;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.bennu.core.domain.User;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectKey;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;
import pt.ist.fenixframework.FenixFramework;

public class MetaObjectCollection
extends MetaObject {
    private final List<MetaObject> metaObjects = new ArrayList<MetaObject>();

    public List<MetaObject> getAllMetaObjects() {
        return this.metaObjects;
    }

    public void add(MetaObject metaObject) {
        this.metaObjects.add(metaObject);
    }

    public boolean remove(MetaObject metaObject) {
        return this.metaObjects.remove(metaObject);
    }

    @Override
    public void setUser(User user) {
        super.setUser(user);
        for (MetaObject metaObject : this.getAllMetaObjects()) {
            metaObject.setUser(user);
        }
    }

    @Override
    public Object getObject() {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (MetaObject metaObject : this.getAllMetaObjects()) {
            objects.add(metaObject.getObject());
        }
        return objects;
    }

    @Override
    public Class getType() {
        return ArrayList.class;
    }

    @Override
    public List<MetaSlot> getSlots() {
        ArrayList<MetaSlot> slots = new ArrayList<MetaSlot>();
        for (MetaObject metaObject : this.getAllMetaObjects()) {
            slots.addAll(metaObject.getSlots());
        }
        return slots;
    }

    @Override
    public void addSlot(MetaSlot slot) {
    }

    @Override
    public boolean removeSlot(MetaSlot slot) {
        return false;
    }

    @Override
    public MetaObjectKey getKey() {
        return null;
    }

    @Override
    public List<MetaSlot> getHiddenSlots() {
        ArrayList<MetaSlot> slots = new ArrayList<MetaSlot>();
        for (MetaObject metaObject : this.getAllMetaObjects()) {
            slots.addAll(metaObject.getHiddenSlots());
        }
        return slots;
    }

    @Override
    public void addHiddenSlot(MetaSlot slot) {
    }

    public void commitChanges() {
        FenixFramework.atomic(this::commit);
    }

    @Override
    protected void commit() {
        for (MetaObject metaObject : this.getAllMetaObjects()) {
            metaObject.commit();
        }
    }
}

