/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.fenixedu.bennu.core.domain.User;
import pt.ist.fenixWebFramework.renderers.model.InstanceCreator;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectKey;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;
import pt.ist.fenixWebFramework.renderers.schemas.Schema;
import pt.ist.fenixWebFramework.renderers.utils.RenderKit;

public abstract class MetaObject
implements Serializable {
    private Properties properties = new Properties();
    private transient User user;
    private final List<MetaSlot> slots = new ArrayList<MetaSlot>();
    private final List<MetaSlot> hiddenSlots = new ArrayList<MetaSlot>();
    private InstanceCreator creator;
    private String schemaName;
    private transient Schema schema;

    public abstract Object getObject();

    public Class getType() {
        Object object = this.getObject();
        if (object == null) {
            return null;
        }
        return object.getClass();
    }

    public Schema getSchema() {
        if (this.schema == null && this.schemaName != null) {
            this.schema = RenderKit.getInstance().findSchema(this.schemaName);
        }
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
        if (this.schema != null) {
            this.schemaName = this.schema.getName();
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public abstract MetaObjectKey getKey();

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        if (this.user != null && this.user.equals((Object)user)) {
            return;
        }
        this.user = user;
    }

    public List<MetaSlot> getSlots() {
        return this.slots;
    }

    public MetaSlot getSlot(String name) {
        if (name == null) {
            return null;
        }
        for (MetaSlot slot : this.getAllSlots()) {
            if (!slot.getName().equals(name)) continue;
            return slot;
        }
        return null;
    }

    public void addSlot(MetaSlot slot) {
        this.slots.add(slot);
    }

    public boolean removeSlot(MetaSlot slot) {
        return this.slots.remove(slot);
    }

    public List<MetaSlot> getHiddenSlots() {
        return this.hiddenSlots;
    }

    public void addHiddenSlot(MetaSlot slot) {
        this.hiddenSlots.add(slot);
    }

    public List<MetaSlot> getAllSlots() {
        ArrayList<MetaSlot> all = new ArrayList<MetaSlot>();
        all.addAll(this.getSlots());
        all.addAll(this.getHiddenSlots());
        return all;
    }

    public void setInstanceCreator(InstanceCreator creator) {
        this.creator = creator;
    }

    public InstanceCreator getInstanceCreator() {
        return this.creator;
    }

    protected abstract void commit();
}

