/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.components;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.PageContext;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.tags.HtmlTag;

public class HtmlTableCell
extends HtmlComponent {
    private CellType type;
    private HtmlComponent data;
    private String abbr;
    private String axis;
    private String headers;
    private String scope;
    private Integer rowspan;
    private Integer colspan;
    private String align;
    private String valign;

    public HtmlTableCell() {
        this(CellType.DATA);
    }

    public HtmlTableCell(String text) {
        this();
        this.setText(text);
    }

    public HtmlTableCell(CellType header) {
        this.type = header;
    }

    public CellType getType() {
        return this.type;
    }

    public void setType(CellType type) {
        this.type = type;
    }

    public String getAbbr() {
        return this.abbr;
    }

    public void setAbbr(String abbr) {
        this.abbr = abbr;
    }

    public String getAxis() {
        return this.axis;
    }

    public void setAxis(String axis) {
        this.axis = axis;
    }

    public Integer getColspan() {
        return this.colspan;
    }

    public void setColspan(Integer colspan) {
        this.colspan = colspan;
    }

    public String getHeaders() {
        return this.headers;
    }

    public void setHeaders(String headers) {
        this.headers = headers;
    }

    public Integer getRowspan() {
        return this.rowspan;
    }

    public void setRowspan(Integer rowspan) {
        this.rowspan = rowspan;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getAlign() {
        return this.align;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public String getValign() {
        return this.valign;
    }

    public void setValign(String valign) {
        this.valign = valign;
    }

    public void setText(String text) {
        this.data = new HtmlText(text);
    }

    public void setBody(HtmlComponent body) {
        this.data = body;
    }

    public HtmlComponent getBody() {
        return this.data;
    }

    @Override
    public List<HtmlComponent> getChildren() {
        ArrayList<HtmlComponent> children = new ArrayList<HtmlComponent>(super.getChildren());
        if (this.getBody() != null) {
            children.add(this.getBody());
        }
        return children;
    }

    @Override
    public HtmlTag getOwnTag(PageContext context) {
        HtmlTag tag = super.getOwnTag(context);
        tag.setName(this.type.toString());
        tag.setAttribute("abbr", this.getAbbr());
        tag.setAttribute("axis", this.getAxis());
        tag.setAttribute("headers", this.getHeaders());
        tag.setAttribute("scope", this.getScope());
        tag.setAttribute("rowspan", this.getRowspan());
        tag.setAttribute("colspan", this.getColspan());
        tag.setAttribute("align", this.getAlign());
        tag.setAttribute("valign", this.getValign());
        if (this.data != null) {
            tag.addChild(this.data.getOwnTag(context));
        }
        return tag;
    }

    public static enum CellType {
        DATA,
        HEADER;


        public String toString() {
            String[] names = new String[]{"td", "th"};
            return names[this.ordinal()];
        }
    }
}

