/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.components;

import javax.servlet.ServletRequest;
import javax.servlet.jsp.PageContext;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.tags.HtmlTag;

public class HtmlScript
extends HtmlComponent {
    private String charset;
    private String contentType;
    private String source;
    private boolean defer;
    private boolean conditional;
    private CharSequence script;

    public HtmlScript() {
    }

    public HtmlScript(String contentType, String source) {
        this.contentType = contentType;
        this.source = source;
    }

    public HtmlScript(String contentType, String source, boolean conditional) {
        this(contentType, source);
        this.conditional = conditional;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public boolean isDefer() {
        return this.defer;
    }

    public void setDefer(boolean defer) {
        this.defer = defer;
    }

    public boolean isConditional() {
        return this.conditional;
    }

    public void setConditional(boolean conditional) {
        this.conditional = conditional;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public CharSequence getScript() {
        return this.script;
    }

    public void setScript(CharSequence script) {
        this.script = script;
    }

    @Override
    public HtmlTag getOwnTag(PageContext context) {
        HtmlTag tag = super.getOwnTag(context);
        if (this.isConditional() && this.wasIncluded(context)) {
            tag.setName(null);
            return tag;
        }
        tag.setName("script");
        tag.setAttribute("charset", this.getCharset());
        tag.setAttribute("type", this.getContentType());
        tag.setAttribute("src", this.getSource());
        if (this.isDefer()) {
            tag.setAttribute("defer", "defer");
        }
        if (this.getScript() != null) {
            tag.setText(this.getScript().toString());
        }
        return tag;
    }

    private boolean wasIncluded(PageContext context) {
        String conditionalName;
        String includeId = null;
        if (this.getSource() != null) {
            includeId = this.getSource();
        } else if (this.getScript() != null) {
            includeId = String.valueOf(this.getScript().hashCode());
        }
        if (includeId == null) {
            return false;
        }
        ServletRequest request = context.getRequest();
        if (request.getAttribute(conditionalName = this.getClass().getName() + "/included/" + includeId) != null) {
            return true;
        }
        request.setAttribute(conditionalName, (Object)true);
        return false;
    }
}

