/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.components;

import javax.servlet.jsp.PageContext;
import pt.ist.fenixWebFramework.renderers.components.HtmlHiddenField;
import pt.ist.fenixWebFramework.renderers.components.HtmlMultipleValueComponent;
import pt.ist.fenixWebFramework.renderers.components.tags.HtmlTag;

public class HtmlMultipleHiddenField
extends HtmlMultipleValueComponent {
    public HtmlMultipleHiddenField(String name) {
        this.setName(name);
    }

    public HtmlMultipleHiddenField() {
    }

    public void addValue(String value) {
        String[] values = this.getValues();
        if (values == null) {
            this.setValues(value);
        } else {
            String[] newValues = new String[values.length + 1];
            for (int i = 0; i < values.length; ++i) {
                newValues[i] = values[i];
            }
            newValues[values.length] = value;
            this.setValues(newValues);
        }
    }

    public void removeValue(int i) {
        String[] values = this.getValues();
        if (values == null) {
            return;
        }
        if (i < 0 || i >= values.length) {
            return;
        }
        if (values.length == 1) {
            this.setValues(null);
            return;
        }
        String[] newValues = new String[values.length - 1];
        for (int j = 0; j < newValues.length; ++j) {
            newValues[j] = j < i ? values[j] : values[j + 1];
        }
        this.setValues(newValues);
    }

    @Override
    public HtmlTag getOwnTag(PageContext context) {
        String[] values;
        HtmlTag tag = super.getOwnTag(context);
        tag.setName(null);
        for (String value : values = this.getValues()) {
            HtmlHiddenField hidden = new HtmlHiddenField(this.getName(), value);
            hidden.setTargetSlot(this.getTargetSlot());
            tag.addChild(hidden.getOwnTag(context));
        }
        return tag;
    }
}

